@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan data for an extension resource.
 * @property name Name of the plan.
 * @property product Product name.
 * @property promotionCode Optional: the promotion code associated with the plan.
 * @property publisher Name of the extension publisher.
 * @property version A string that uniquely identifies the plan version.
 */
public data class ExtensionResourcePlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.visualstudio.outputs.ExtensionResourcePlanResponse): ExtensionResourcePlanResponse = ExtensionResourcePlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
