@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The response to an account resource GET request.
 * @property id Unique identifier of the resource.
 * @property location Resource location.
 * @property name Resource name.
 * @property properties Resource properties.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetAccountResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: Map<String, String>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.visualstudio.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
