@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DedicatedCloudService].
 */
@PulumiTagMarker
public class DedicatedCloudServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedCloudServiceArgs = DedicatedCloudServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedCloudServiceArgsBuilder.() -> Unit) {
        val builder = DedicatedCloudServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedCloudService {
        val builtJavaResource =
            com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DedicatedCloudService(builtJavaResource)
    }
}

/**
 * Dedicated cloud service model
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### CreateDedicatedCloudService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedCloudService = new AzureNative.VMwareCloudSimple.DedicatedCloudService("dedicatedCloudService", new()
 *     {
 *         DedicatedCloudServiceName = "myService",
 *         GatewaySubnet = "10.0.0.0",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/vmwarecloudsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := vmwarecloudsimple.NewDedicatedCloudService(ctx, "dedicatedCloudService", &vmwarecloudsimple.DedicatedCloudServiceArgs{
 * 			DedicatedCloudServiceName: pulumi.String("myService"),
 * 			GatewaySubnet:             pulumi.String("10.0.0.0"),
 * 			Location:                  pulumi.String("westus"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService;
 * import com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedCloudService = new DedicatedCloudService("dedicatedCloudService", DedicatedCloudServiceArgs.builder()
 *             .dedicatedCloudServiceName("myService")
 *             .gatewaySubnet("10.0.0.0")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:vmwarecloudsimple:DedicatedCloudService myService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VMwareCloudSimple/dedicatedCloudServices/{dedicatedCloudServiceName}
 * ```
 */
public class DedicatedCloudService internal constructor(
    override val javaResource: com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService,
) : KotlinCustomResource(javaResource, DedicatedCloudServiceMapper) {
    /**
     * gateway Subnet for the account. It will collect the subnet address and always treat it as /28
     */
    public val gatewaySubnet: Output<String>
        get() = javaResource.gatewaySubnet().applyValue({ args0 -> args0 })

    /**
     * indicates whether account onboarded or not in a given region
     */
    public val isAccountOnboarded: Output<String>
        get() = javaResource.isAccountOnboarded().applyValue({ args0 -> args0 })

    /**
     * Azure region
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * {dedicatedCloudServiceName}
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * total nodes purchased
     */
    public val nodes: Output<Int>
        get() = javaResource.nodes().applyValue({ args0 -> args0 })

    /**
     * link to a service management web portal
     */
    public val serviceURL: Output<String>
        get() = javaResource.serviceURL().applyValue({ args0 -> args0 })

    /**
     * The list of tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * {resourceProviderNamespace}/{resourceType}
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DedicatedCloudServiceMapper : ResourceMapper<DedicatedCloudService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedCloudService =
        DedicatedCloudService(
            javaResource as
                com.pulumi.azurenative.vmwarecloudsimple.DedicatedCloudService,
        )
}

/**
 * @see [DedicatedCloudService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedCloudService].
 */
public suspend fun dedicatedCloudService(
    name: String,
    block: suspend DedicatedCloudServiceResourceBuilder.() -> Unit,
): DedicatedCloudService {
    val builder = DedicatedCloudServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedCloudService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedCloudService(name: String): DedicatedCloudService {
    val builder = DedicatedCloudServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
