@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource pool model
 * @property id resource pool id (privateCloudId:vsphereId)
 */
public data class ResourcePoolArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.ResourcePoolArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePoolArgs].
 */
@PulumiTagMarker
public class ResourcePoolArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value resource pool id (privateCloudId:vsphereId)
     */
    @JvmName("svphbfxeyronppvq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value resource pool id (privateCloudId:vsphereId)
     */
    @JvmName("kwlislaqpaqtokpy")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ResourcePoolArgs = ResourcePoolArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
