@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Dedicated cloud node model
 * @property availabilityZoneId Availability Zone id, e.g. "az1"
 * @property availabilityZoneName Availability Zone name, e.g. "Availability Zone 1"
 * @property cloudRackName VMWare Cloud Rack Name
 * @property created date time the resource was created
 * @property id SKU's id
 * @property location Azure region
 * @property name SKU's name
 * @property nodesCount count of nodes to create
 * @property placementGroupId Placement Group id, e.g. "n1"
 * @property placementGroupName Placement Name, e.g. "Placement Group 1"
 * @property privateCloudId Private Cloud Id
 * @property privateCloudName Resource Pool Name
 * @property provisioningState The provisioning status of the resource
 * @property purchaseId purchase id
 * @property sku Dedicated Cloud Nodes SKU
 * @property status Node status, indicates is private cloud set up on this node or not
 * @property tags Dedicated Cloud Nodes tags
 * @property type {resourceProviderNamespace}/{resourceType}
 * @property vmwareClusterName VMWare Cluster Name
 */
public data class GetDedicatedCloudNodeResult(
    public val availabilityZoneId: String,
    public val availabilityZoneName: String,
    public val cloudRackName: String,
    public val created: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val nodesCount: Int,
    public val placementGroupId: String,
    public val placementGroupName: String,
    public val privateCloudId: String,
    public val privateCloudName: String,
    public val provisioningState: String,
    public val purchaseId: String,
    public val sku: SkuResponse? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmwareClusterName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.GetDedicatedCloudNodeResult): GetDedicatedCloudNodeResult = GetDedicatedCloudNodeResult(
            availabilityZoneId = javaType.availabilityZoneId(),
            availabilityZoneName = javaType.availabilityZoneName(),
            cloudRackName = javaType.cloudRackName(),
            created = javaType.created(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            nodesCount = javaType.nodesCount(),
            placementGroupId = javaType.placementGroupId(),
            placementGroupName = javaType.placementGroupName(),
            privateCloudId = javaType.privateCloudId(),
            privateCloudName = javaType.privateCloudName(),
            provisioningState = javaType.provisioningState(),
            purchaseId = javaType.purchaseId(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmwareClusterName = javaType.vmwareClusterName(),
        )
    }
}
