@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Dedicated cloud service model
 * @property gatewaySubnet gateway Subnet for the account. It will collect the subnet address and always treat it as /28
 * @property id /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/dedicatedCloudServices/{dedicatedCloudServiceName}
 * @property isAccountOnboarded indicates whether account onboarded or not in a given region
 * @property location Azure region
 * @property name {dedicatedCloudServiceName}
 * @property nodes total nodes purchased
 * @property serviceURL link to a service management web portal
 * @property tags The list of tags
 * @property type {resourceProviderNamespace}/{resourceType}
 */
public data class GetDedicatedCloudServiceResult(
    public val gatewaySubnet: String,
    public val id: String,
    public val isAccountOnboarded: String,
    public val location: String,
    public val name: String,
    public val nodes: Int,
    public val serviceURL: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.GetDedicatedCloudServiceResult): GetDedicatedCloudServiceResult = GetDedicatedCloudServiceResult(
            gatewaySubnet = javaType.gatewaySubnet(),
            id = javaType.id(),
            isAccountOnboarded = javaType.isAccountOnboarded(),
            location = javaType.location(),
            name = javaType.name(),
            nodes = javaType.nodes(),
            serviceURL = javaType.serviceURL(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
