@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Virtual machine model
 * @property amountOfRam The amount of memory
 * @property controllers The list of Virtual Disks' Controllers
 * @property customization Virtual machine properties
 * @property disks The list of Virtual Disks
 * @property dnsname The DNS name of Virtual Machine in VCenter
 * @property exposeToGuestVM Expose Guest OS or not
 * @property folder The path to virtual machine folder in VCenter
 * @property guestOS The name of Guest OS
 * @property guestOSType The Guest OS type
 * @property id /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/virtualMachines/{virtualMachineName}
 * @property location Azure region
 * @property name {virtualMachineName}
 * @property nics The list of Virtual NICs
 * @property numberOfCores The number of CPU cores
 * @property password Password for login. Deprecated - use customization property
 * @property privateCloudId Private Cloud Id
 * @property provisioningState The provisioning status of the resource
 * @property publicIP The public ip of Virtual Machine
 * @property resourcePool Virtual Machines Resource Pool
 * @property status The status of Virtual machine
 * @property tags The list of tags
 * @property templateId Virtual Machine Template Id
 * @property type {resourceProviderNamespace}/{resourceType}
 * @property username Username for login. Deprecated - use customization property
 * @property vSphereNetworks The list of Virtual VSphere Networks
 * @property vmId The internal id of Virtual Machine in VCenter
 * @property vmwaretools VMware tools version
 */
public data class GetVirtualMachineResult(
    public val amountOfRam: Int,
    public val controllers: List<VirtualDiskControllerResponse>,
    public val customization: GuestOSCustomizationResponse? = null,
    public val disks: List<VirtualDiskResponse>? = null,
    public val dnsname: String,
    public val exposeToGuestVM: Boolean? = null,
    public val folder: String,
    public val guestOS: String,
    public val guestOSType: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val nics: List<VirtualNicResponse>? = null,
    public val numberOfCores: Int,
    public val password: String? = null,
    public val privateCloudId: String,
    public val provisioningState: String,
    public val publicIP: String,
    public val resourcePool: ResourcePoolResponse? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val templateId: String? = null,
    public val type: String,
    public val username: String? = null,
    public val vSphereNetworks: List<String>? = null,
    public val vmId: String,
    public val vmwaretools: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.GetVirtualMachineResult): GetVirtualMachineResult = GetVirtualMachineResult(
            amountOfRam = javaType.amountOfRam(),
            controllers = javaType.controllers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskControllerResponse.Companion.toKotlin(args0)
                })
            }),
            customization = javaType.customization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GuestOSCustomizationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin(args0)
                })
            }),
            dnsname = javaType.dnsname(),
            exposeToGuestVM = javaType.exposeToGuestVM().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder(),
            guestOS = javaType.guestOS(),
            guestOSType = javaType.guestOSType(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            nics = javaType.nics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualNicResponse.Companion.toKotlin(args0)
                })
            }),
            numberOfCores = javaType.numberOfCores(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            privateCloudId = javaType.privateCloudId(),
            provisioningState = javaType.provisioningState(),
            publicIP = javaType.publicIP(),
            resourcePool = javaType.resourcePool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.ResourcePoolResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
            vSphereNetworks = javaType.vSphereNetworks().map({ args0 -> args0 }),
            vmId = javaType.vmId(),
            vmwaretools = javaType.vmwaretools(),
        )
    }
}
