@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Guest OS Customization properties
 * @property dnsServers List of dns servers to use
 * @property hostName Virtual Machine hostname
 * @property password Password for login
 * @property policyId id of customization policy
 * @property username Username for login
 */
public data class GuestOSCustomizationResponse(
    public val dnsServers: List<String>? = null,
    public val hostName: String? = null,
    public val password: String? = null,
    public val policyId: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.GuestOSCustomizationResponse): GuestOSCustomizationResponse = GuestOSCustomizationResponse(
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
