@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Guest OS nic customization
 * @property allocation IP address allocation method
 * @property dnsServers List of dns servers to use
 * @property gateway Gateway addresses assigned to nic
 * @property ipAddress Static ip address for nic
 * @property mask Network mask for nic
 * @property primaryWinsServer primary WINS server for Windows
 * @property secondaryWinsServer secondary WINS server for Windows
 */
public data class GuestOSNICCustomizationResponse(
    public val allocation: String? = null,
    public val dnsServers: List<String>? = null,
    public val gateway: List<String>? = null,
    public val ipAddress: String? = null,
    public val mask: String? = null,
    public val primaryWinsServer: String? = null,
    public val secondaryWinsServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.GuestOSNICCustomizationResponse): GuestOSNICCustomizationResponse = GuestOSNICCustomizationResponse(
            allocation = javaType.allocation().map({ args0 -> args0 }).orElse(null),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            gateway = javaType.gateway().map({ args0 -> args0 }),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            mask = javaType.mask().map({ args0 -> args0 }).orElse(null),
            primaryWinsServer = javaType.primaryWinsServer().map({ args0 -> args0 }).orElse(null),
            secondaryWinsServer = javaType.secondaryWinsServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
