@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual disk controller model
 * @property id Controller's id
 * @property name The display name of Controller
 * @property subType dik controller subtype (VMWARE_PARAVIRTUAL, BUS_PARALLEL, LSI_PARALLEL, LSI_SAS)
 * @property type disk controller type (SCSI)
 */
public data class VirtualDiskControllerResponse(
    public val id: String,
    public val name: String,
    public val subType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.VirtualDiskControllerResponse): VirtualDiskControllerResponse = VirtualDiskControllerResponse(
            id = javaType.id(),
            name = javaType.name(),
            subType = javaType.subType(),
            type = javaType.type(),
        )
    }
}
