@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Virtual disk model
 * @property controllerId Disk's Controller id
 * @property independenceMode Disk's independence mode type
 * @property totalSize Disk's total size
 * @property virtualDiskId Disk's id
 * @property virtualDiskName Disk's display name
 */
public data class VirtualDiskResponse(
    public val controllerId: String,
    public val independenceMode: String,
    public val totalSize: Int,
    public val virtualDiskId: String? = null,
    public val virtualDiskName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.VirtualDiskResponse): VirtualDiskResponse = VirtualDiskResponse(
            controllerId = javaType.controllerId(),
            independenceMode = javaType.independenceMode(),
            totalSize = javaType.totalSize(),
            virtualDiskId = javaType.virtualDiskId().map({ args0 -> args0 }).orElse(null),
            virtualDiskName = javaType.virtualDiskName(),
        )
    }
}
