@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Virtual NIC model
 * @property customization guest OS customization for nic
 * @property ipAddresses NIC ip address
 * @property macAddress NIC MAC address
 * @property network Virtual Network
 * @property nicType NIC type
 * @property powerOnBoot Is NIC powered on/off on boot
 * @property virtualNicId NIC id
 * @property virtualNicName NIC name
 */
public data class VirtualNicResponse(
    public val customization: GuestOSNICCustomizationResponse? = null,
    public val ipAddresses: List<String>? = null,
    public val macAddress: String? = null,
    public val network: VirtualNetworkResponse,
    public val nicType: String,
    public val powerOnBoot: Boolean? = null,
    public val virtualNicId: String? = null,
    public val virtualNicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.VirtualNicResponse): VirtualNicResponse = VirtualNicResponse(
            customization = javaType.customization().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.GuestOSNICCustomizationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            macAddress = javaType.macAddress().map({ args0 -> args0 }).orElse(null),
            network = javaType.network().let({ args0 ->
                com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs.VirtualNetworkResponse.Companion.toKotlin(args0)
            }),
            nicType = javaType.nicType(),
            powerOnBoot = javaType.powerOnBoot().map({ args0 -> args0 }).orElse(null),
            virtualNicId = javaType.virtualNicId().map({ args0 -> args0 }).orElse(null),
            virtualNicName = javaType.virtualNicName(),
        )
    }
}
