@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs.builder
import com.pulumi.azurenative.voiceservices.kotlin.enums.AutoGeneratedDomainNameLabelScope
import com.pulumi.azurenative.voiceservices.kotlin.enums.CommunicationsPlatform
import com.pulumi.azurenative.voiceservices.kotlin.enums.Connectivity
import com.pulumi.azurenative.voiceservices.kotlin.enums.E911Type
import com.pulumi.azurenative.voiceservices.kotlin.enums.TeamsCodecs
import com.pulumi.azurenative.voiceservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.voiceservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.voiceservices.kotlin.inputs.ServiceRegionPropertiesArgs
import com.pulumi.azurenative.voiceservices.kotlin.inputs.ServiceRegionPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A CommunicationsGateway resource
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### CreateCommunicationsGatewayResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communicationsGateway = new AzureNative.VoiceServices.CommunicationsGateway("communicationsGateway", new()
 *     {
 *         AutoGeneratedDomainNameLabelScope = AzureNative.VoiceServices.AutoGeneratedDomainNameLabelScope.NoReuse,
 *         Codecs = new[]
 *         {
 *             AzureNative.VoiceServices.TeamsCodecs.PCMA,
 *         },
 *         CommunicationsGatewayName = "myname",
 *         Connectivity = AzureNative.VoiceServices.Connectivity.PublicAddress,
 *         E911Type = AzureNative.VoiceServices.E911Type.Standard,
 *         Location = "useast",
 *         Platforms = new[]
 *         {
 *             AzureNative.VoiceServices.CommunicationsPlatform.OperatorConnect,
 *         },
 *         ResourceGroupName = "testrg",
 *         ServiceLocations = new[]
 *         {
 *             new AzureNative.VoiceServices.Inputs.ServiceRegionPropertiesArgs
 *             {
 *                 Name = "useast",
 *                 PrimaryRegionProperties = new AzureNative.VoiceServices.Inputs.PrimaryRegionPropertiesArgs
 *                 {
 *                     AllowedMediaSourceAddressPrefixes = new[]
 *                     {
 *                         "10.1.2.0/24",
 *                     },
 *                     AllowedSignalingSourceAddressPrefixes = new[]
 *                     {
 *                         "10.1.1.0/24",
 *                     },
 *                     OperatorAddresses = new[]
 *                     {
 *                         "198.51.100.1",
 *                     },
 *                 },
 *             },
 *             new AzureNative.VoiceServices.Inputs.ServiceRegionPropertiesArgs
 *             {
 *                 Name = "useast2",
 *                 PrimaryRegionProperties = new AzureNative.VoiceServices.Inputs.PrimaryRegionPropertiesArgs
 *                 {
 *                     AllowedMediaSourceAddressPrefixes = new[]
 *                     {
 *                         "10.2.2.0/24",
 *                     },
 *                     AllowedSignalingSourceAddressPrefixes = new[]
 *                     {
 *                         "10.2.1.0/24",
 *                     },
 *                     OperatorAddresses = new[]
 *                     {
 *                         "198.51.100.2",
 *                     },
 *                 },
 *             },
 *         },
 *         TeamsVoicemailPilotNumber = "1234567890",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewCommunicationsGateway(ctx, "communicationsGateway", &voiceservices.CommunicationsGatewayArgs{
 * 			AutoGeneratedDomainNameLabelScope: pulumi.String(voiceservices.AutoGeneratedDomainNameLabelScopeNoReuse),
 * 			Codecs: pulumi.StringArray{
 * 				pulumi.String(voiceservices.TeamsCodecsPCMA),
 * 			},
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			Connectivity:              pulumi.String(voiceservices.ConnectivityPublicAddress),
 * 			E911Type:                  pulumi.String(voiceservices.E911TypeStandard),
 * 			Location:                  pulumi.String("useast"),
 * 			Platforms: pulumi.StringArray{
 * 				pulumi.String(voiceservices.CommunicationsPlatformOperatorConnect),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServiceLocations: voiceservices.ServiceRegionPropertiesArray{
 * 				&voiceservices.ServiceRegionPropertiesArgs{
 * 					Name: pulumi.String("useast"),
 * 					PrimaryRegionProperties: &voiceservices.PrimaryRegionPropertiesArgs{
 * 						AllowedMediaSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.1.2.0/24"),
 * 						},
 * 						AllowedSignalingSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.1.1.0/24"),
 * 						},
 * 						OperatorAddresses: pulumi.StringArray{
 * 							pulumi.String("198.51.100.1"),
 * 						},
 * 					},
 * 				},
 * 				&voiceservices.ServiceRegionPropertiesArgs{
 * 					Name: pulumi.String("useast2"),
 * 					PrimaryRegionProperties: &voiceservices.PrimaryRegionPropertiesArgs{
 * 						AllowedMediaSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.2.2.0/24"),
 * 						},
 * 						AllowedSignalingSourceAddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("10.2.1.0/24"),
 * 						},
 * 						OperatorAddresses: pulumi.StringArray{
 * 							pulumi.String("198.51.100.2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			TeamsVoicemailPilotNumber: pulumi.String("1234567890"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.CommunicationsGateway;
 * import com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs;
 * import com.pulumi.azurenative.voiceservices.inputs.ServiceRegionPropertiesArgs;
 * import com.pulumi.azurenative.voiceservices.inputs.PrimaryRegionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communicationsGateway = new CommunicationsGateway("communicationsGateway", CommunicationsGatewayArgs.builder()
 *             .autoGeneratedDomainNameLabelScope("NoReuse")
 *             .codecs("PCMA")
 *             .communicationsGatewayName("myname")
 *             .connectivity("PublicAddress")
 *             .e911Type("Standard")
 *             .location("useast")
 *             .platforms("OperatorConnect")
 *             .resourceGroupName("testrg")
 *             .serviceLocations(
 *                 ServiceRegionPropertiesArgs.builder()
 *                     .name("useast")
 *                     .primaryRegionProperties(PrimaryRegionPropertiesArgs.builder()
 *                         .allowedMediaSourceAddressPrefixes("10.1.2.0/24")
 *                         .allowedSignalingSourceAddressPrefixes("10.1.1.0/24")
 *                         .operatorAddresses("198.51.100.1")
 *                         .build())
 *                     .build(),
 *                 ServiceRegionPropertiesArgs.builder()
 *                     .name("useast2")
 *                     .primaryRegionProperties(PrimaryRegionPropertiesArgs.builder()
 *                         .allowedMediaSourceAddressPrefixes("10.2.2.0/24")
 *                         .allowedSignalingSourceAddressPrefixes("10.2.1.0/24")
 *                         .operatorAddresses("198.51.100.2")
 *                         .build())
 *                     .build())
 *             .teamsVoicemailPilotNumber("1234567890")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:CommunicationsGateway myname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}
 * ```
 * @property apiBridge Details of API bridge functionality, if required
 * @property autoGeneratedDomainNameLabelScope The scope at which the auto-generated domain name can be re-used
 * @property codecs Voice codecs to support
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property connectivity How to connect back to the operator network, e.g. MAPS
 * @property e911Type How to handle 911 calls
 * @property emergencyDialStrings A list of dial strings used for emergency calling.
 * @property identity The managed service identities assigned to this resource.
 * @property integratedMcpEnabled Whether an integrated Mobile Control Point is in use.
 * @property location The geo-location where the resource lives
 * @property onPremMcpEnabled Whether an on-premises Mobile Control Point is in use.
 * @property platforms What platforms to support
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceLocations The regions in which to deploy the resources needed for Teams Calling
 * @property tags Resource tags.
 * @property teamsVoicemailPilotNumber This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
 */
public data class CommunicationsGatewayArgs(
    public val apiBridge: Output<Any>? = null,
    public val autoGeneratedDomainNameLabelScope: Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null,
    public val codecs: Output<List<Either<String, TeamsCodecs>>>? = null,
    public val communicationsGatewayName: Output<String>? = null,
    public val connectivity: Output<Either<String, Connectivity>>? = null,
    public val e911Type: Output<Either<String, E911Type>>? = null,
    public val emergencyDialStrings: Output<List<String>>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val integratedMcpEnabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val onPremMcpEnabled: Output<Boolean>? = null,
    public val platforms: Output<List<Either<String, CommunicationsPlatform>>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceLocations: Output<List<ServiceRegionPropertiesArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val teamsVoicemailPilotNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs =
        com.pulumi.azurenative.voiceservices.CommunicationsGatewayArgs.builder()
            .apiBridge(apiBridge?.applyValue({ args0 -> args0 }))
            .autoGeneratedDomainNameLabelScope(
                autoGeneratedDomainNameLabelScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .codecs(
                codecs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .communicationsGatewayName(communicationsGatewayName?.applyValue({ args0 -> args0 }))
            .connectivity(
                connectivity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .e911Type(
                e911Type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emergencyDialStrings(emergencyDialStrings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integratedMcpEnabled(integratedMcpEnabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .onPremMcpEnabled(onPremMcpEnabled?.applyValue({ args0 -> args0 }))
            .platforms(
                platforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceLocations(
                serviceLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .teamsVoicemailPilotNumber(teamsVoicemailPilotNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommunicationsGatewayArgs].
 */
@PulumiTagMarker
public class CommunicationsGatewayArgsBuilder internal constructor() {
    private var apiBridge: Output<Any>? = null

    private var autoGeneratedDomainNameLabelScope:
        Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null

    private var codecs: Output<List<Either<String, TeamsCodecs>>>? = null

    private var communicationsGatewayName: Output<String>? = null

    private var connectivity: Output<Either<String, Connectivity>>? = null

    private var e911Type: Output<Either<String, E911Type>>? = null

    private var emergencyDialStrings: Output<List<String>>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var integratedMcpEnabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var onPremMcpEnabled: Output<Boolean>? = null

    private var platforms: Output<List<Either<String, CommunicationsPlatform>>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceLocations: Output<List<ServiceRegionPropertiesArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var teamsVoicemailPilotNumber: Output<String>? = null

    /**
     * @param value Details of API bridge functionality, if required
     */
    @JvmName("xwmbdrvtrymxcjqf")
    public suspend fun apiBridge(`value`: Output<Any>) {
        this.apiBridge = value
    }

    /**
     * @param value The scope at which the auto-generated domain name can be re-used
     */
    @JvmName("kgipjoqudgorwyxq")
    public suspend fun autoGeneratedDomainNameLabelScope(`value`: Output<Either<String, AutoGeneratedDomainNameLabelScope>>) {
        this.autoGeneratedDomainNameLabelScope = value
    }

    /**
     * @param value Voice codecs to support
     */
    @JvmName("gbxwnrvgoouavvlq")
    public suspend fun codecs(`value`: Output<List<Either<String, TeamsCodecs>>>) {
        this.codecs = value
    }

    @JvmName("mhvjwhiirqplhrhu")
    public suspend fun codecs(vararg values: Output<Either<String, TeamsCodecs>>) {
        this.codecs = Output.all(values.asList())
    }

    /**
     * @param values Voice codecs to support
     */
    @JvmName("snyukaupgaoxolgl")
    public suspend fun codecs(values: List<Output<Either<String, TeamsCodecs>>>) {
        this.codecs = Output.all(values)
    }

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("kpqpycvsvwyioyil")
    public suspend fun communicationsGatewayName(`value`: Output<String>) {
        this.communicationsGatewayName = value
    }

    /**
     * @param value How to connect back to the operator network, e.g. MAPS
     */
    @JvmName("gghncjbnxurflyas")
    public suspend fun connectivity(`value`: Output<Either<String, Connectivity>>) {
        this.connectivity = value
    }

    /**
     * @param value How to handle 911 calls
     */
    @JvmName("owtngcvacgbfnlll")
    public suspend fun e911Type(`value`: Output<Either<String, E911Type>>) {
        this.e911Type = value
    }

    /**
     * @param value A list of dial strings used for emergency calling.
     */
    @JvmName("gnegweajsbgnkili")
    public suspend fun emergencyDialStrings(`value`: Output<List<String>>) {
        this.emergencyDialStrings = value
    }

    @JvmName("jhnabuswnfiwqfks")
    public suspend fun emergencyDialStrings(vararg values: Output<String>) {
        this.emergencyDialStrings = Output.all(values.asList())
    }

    /**
     * @param values A list of dial strings used for emergency calling.
     */
    @JvmName("tobkgklxxvsvxllo")
    public suspend fun emergencyDialStrings(values: List<Output<String>>) {
        this.emergencyDialStrings = Output.all(values)
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("bextoxvheyrixjxc")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Whether an integrated Mobile Control Point is in use.
     */
    @JvmName("fnkfjtigoxepayer")
    public suspend fun integratedMcpEnabled(`value`: Output<Boolean>) {
        this.integratedMcpEnabled = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wyyutfkfthughyis")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether an on-premises Mobile Control Point is in use.
     */
    @JvmName("axeitbpuevikxhow")
    public suspend fun onPremMcpEnabled(`value`: Output<Boolean>) {
        this.onPremMcpEnabled = value
    }

    /**
     * @param value What platforms to support
     */
    @JvmName("mnwkiycjcjovtomi")
    public suspend fun platforms(`value`: Output<List<Either<String, CommunicationsPlatform>>>) {
        this.platforms = value
    }

    @JvmName("qjaqfsbvmwxbkgbv")
    public suspend fun platforms(vararg values: Output<Either<String, CommunicationsPlatform>>) {
        this.platforms = Output.all(values.asList())
    }

    /**
     * @param values What platforms to support
     */
    @JvmName("rfpynlmjybjbcpxk")
    public suspend fun platforms(values: List<Output<Either<String, CommunicationsPlatform>>>) {
        this.platforms = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("trjudaaaejqvjypb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("bvluotyqdqaatulg")
    public suspend fun serviceLocations(`value`: Output<List<ServiceRegionPropertiesArgs>>) {
        this.serviceLocations = value
    }

    @JvmName("fxgkntroqgentcug")
    public suspend fun serviceLocations(vararg values: Output<ServiceRegionPropertiesArgs>) {
        this.serviceLocations = Output.all(values.asList())
    }

    /**
     * @param values The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("ckgbbchypueglkfp")
    public suspend fun serviceLocations(values: List<Output<ServiceRegionPropertiesArgs>>) {
        this.serviceLocations = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("brbogoycepmncsxn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
     */
    @JvmName("jjmoeeadwueohauu")
    public suspend fun teamsVoicemailPilotNumber(`value`: Output<String>) {
        this.teamsVoicemailPilotNumber = value
    }

    /**
     * @param value Details of API bridge functionality, if required
     */
    @JvmName("ieabdokplywimkwq")
    public suspend fun apiBridge(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiBridge = mapped
    }

    /**
     * @param value The scope at which the auto-generated domain name can be re-used
     */
    @JvmName("xmolykbelqbcieky")
    public suspend fun autoGeneratedDomainNameLabelScope(`value`: Either<String, AutoGeneratedDomainNameLabelScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The scope at which the auto-generated domain name can be re-used
     */
    @JvmName("yvmhrgbugsfydlpj")
    public fun autoGeneratedDomainNameLabelScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The scope at which the auto-generated domain name can be re-used
     */
    @JvmName("ywyiifwjeeppcgiw")
    public fun autoGeneratedDomainNameLabelScope(`value`: AutoGeneratedDomainNameLabelScope) {
        val toBeMapped = Either.ofRight<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Voice codecs to support
     */
    @JvmName("qoschrjnecgqasgn")
    public suspend fun codecs(`value`: List<Either<String, TeamsCodecs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecs = mapped
    }

    /**
     * @param values Voice codecs to support
     */
    @JvmName("rdtsbqbjidbuvfou")
    public suspend fun codecs(vararg values: Either<String, TeamsCodecs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codecs = mapped
    }

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("kefkmqaevlrrdqvo")
    public suspend fun communicationsGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value How to connect back to the operator network, e.g. MAPS
     */
    @JvmName("mogfgbjfdwsitfco")
    public suspend fun connectivity(`value`: Either<String, Connectivity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivity = mapped
    }

    /**
     * @param value How to connect back to the operator network, e.g. MAPS
     */
    @JvmName("dblrbfnkavqbnqdd")
    public fun connectivity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Connectivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivity = mapped
    }

    /**
     * @param value How to connect back to the operator network, e.g. MAPS
     */
    @JvmName("ouurjaoukolcofjs")
    public fun connectivity(`value`: Connectivity) {
        val toBeMapped = Either.ofRight<String, Connectivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivity = mapped
    }

    /**
     * @param value How to handle 911 calls
     */
    @JvmName("wrougnmhanqjjfnh")
    public suspend fun e911Type(`value`: Either<String, E911Type>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.e911Type = mapped
    }

    /**
     * @param value How to handle 911 calls
     */
    @JvmName("cmgrghliiafqwycr")
    public fun e911Type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, E911Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.e911Type = mapped
    }

    /**
     * @param value How to handle 911 calls
     */
    @JvmName("rnqtwahlqvbemkwo")
    public fun e911Type(`value`: E911Type) {
        val toBeMapped = Either.ofRight<String, E911Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.e911Type = mapped
    }

    /**
     * @param value A list of dial strings used for emergency calling.
     */
    @JvmName("eixcqpjmrefvsrcc")
    public suspend fun emergencyDialStrings(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emergencyDialStrings = mapped
    }

    /**
     * @param values A list of dial strings used for emergency calling.
     */
    @JvmName("cehxxchllmejrxke")
    public suspend fun emergencyDialStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emergencyDialStrings = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("mhdtqyytowqtsqwg")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("kdbnsvhigqvvocac")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Whether an integrated Mobile Control Point is in use.
     */
    @JvmName("foorflppwjbybimj")
    public suspend fun integratedMcpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integratedMcpEnabled = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wksxjpcerojjskyw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether an on-premises Mobile Control Point is in use.
     */
    @JvmName("vbrnaqfiaasguknb")
    public suspend fun onPremMcpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremMcpEnabled = mapped
    }

    /**
     * @param value What platforms to support
     */
    @JvmName("otkohbtsqlshuywc")
    public suspend fun platforms(`value`: List<Either<String, CommunicationsPlatform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platforms = mapped
    }

    /**
     * @param values What platforms to support
     */
    @JvmName("gghdpkteapkvavhj")
    public suspend fun platforms(vararg values: Either<String, CommunicationsPlatform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platforms = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("matvklhqqmcpfyxe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("uckhhlkevwjvypll")
    public suspend fun serviceLocations(`value`: List<ServiceRegionPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLocations = mapped
    }

    /**
     * @param argument The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("iuhnijdqfiubstge")
    public suspend fun serviceLocations(argument: List<suspend ServiceRegionPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceRegionPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLocations = mapped
    }

    /**
     * @param argument The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("jowesohjbjhabpwa")
    public suspend fun serviceLocations(vararg argument: suspend ServiceRegionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceRegionPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLocations = mapped
    }

    /**
     * @param argument The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("ujhjboiprdknpumh")
    public suspend fun serviceLocations(argument: suspend ServiceRegionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceRegionPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceLocations = mapped
    }

    /**
     * @param values The regions in which to deploy the resources needed for Teams Calling
     */
    @JvmName("keupelybwksyignx")
    public suspend fun serviceLocations(vararg values: ServiceRegionPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLocations = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dmoyakwaiqvvifep")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gniqybadpukbgkng")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value This number is used in Teams Phone Mobile scenarios for access to the voicemail IVR from the native dialer.
     */
    @JvmName("nadjrvtrerfgnrrf")
    public suspend fun teamsVoicemailPilotNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamsVoicemailPilotNumber = mapped
    }

    internal fun build(): CommunicationsGatewayArgs = CommunicationsGatewayArgs(
        apiBridge = apiBridge,
        autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope,
        codecs = codecs,
        communicationsGatewayName = communicationsGatewayName,
        connectivity = connectivity,
        e911Type = e911Type,
        emergencyDialStrings = emergencyDialStrings,
        identity = identity,
        integratedMcpEnabled = integratedMcpEnabled,
        location = location,
        onPremMcpEnabled = onPremMcpEnabled,
        platforms = platforms,
        resourceGroupName = resourceGroupName,
        serviceLocations = serviceLocations,
        tags = tags,
        teamsVoicemailPilotNumber = teamsVoicemailPilotNumber,
    )
}
