@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * How to connect back to the operator network, e.g. MAPS
 */
public enum class Connectivity(
    public val javaValue: com.pulumi.azurenative.voiceservices.enums.Connectivity,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.enums.Connectivity> {
    /**
     * This deployment connects to the operator network using a Public IP address, e.g. when using MAPS
     */
    PublicAddress(com.pulumi.azurenative.voiceservices.enums.Connectivity.PublicAddress),
    ;

    override fun toJava(): com.pulumi.azurenative.voiceservices.enums.Connectivity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.enums.Connectivity): Connectivity = Connectivity.values().first { it.javaValue == javaType }
    }
}
