@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * How to handle 911 calls
 */
public enum class E911Type(
    public val javaValue: com.pulumi.azurenative.voiceservices.enums.E911Type,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.enums.E911Type> {
    /**
     * Emergency calls are not handled different from other calls
     */
    Standard(com.pulumi.azurenative.voiceservices.enums.E911Type.Standard),

    /**
     * Emergency calls are routed directly to the ESRP
     */
    DirectToEsrp(com.pulumi.azurenative.voiceservices.enums.E911Type.DirectToEsrp),
    ;

    override fun toJava(): com.pulumi.azurenative.voiceservices.enums.E911Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.enums.E911Type): E911Type =
            E911Type.values().first { it.javaValue == javaType }
    }
}
