@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.inputs

import com.pulumi.azurenative.voiceservices.inputs.GetContactPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property contactName Unique identifier for this contact
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetContactPlainArgs(
    public val communicationsGatewayName: String,
    public val contactName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.inputs.GetContactPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.inputs.GetContactPlainArgs =
        com.pulumi.azurenative.voiceservices.inputs.GetContactPlainArgs.builder()
            .communicationsGatewayName(communicationsGatewayName.let({ args0 -> args0 }))
            .contactName(contactName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactPlainArgs].
 */
@PulumiTagMarker
public class GetContactPlainArgsBuilder internal constructor() {
    private var communicationsGatewayName: String? = null

    private var contactName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("reyyasketxfeidxx")
    public suspend fun communicationsGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value Unique identifier for this contact
     */
    @JvmName("yqwhdobjhlylsqgi")
    public suspend fun contactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sifdvpsbturqeyut")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContactPlainArgs = GetContactPlainArgs(
        communicationsGatewayName = communicationsGatewayName ?: throw
            PulumiNullFieldException("communicationsGatewayName"),
        contactName = contactName ?: throw PulumiNullFieldException("contactName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
