@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.inputs

import com.pulumi.azurenative.voiceservices.inputs.PrimaryRegionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration used in this region as primary, and other regions as backup.
 * @property allowedMediaSourceAddressPrefixes The allowed source IP address or CIDR ranges for media
 * @property allowedSignalingSourceAddressPrefixes The allowed source IP address or CIDR ranges for signaling
 * @property esrpAddresses IP address to use to contact the ESRP from this region
 * @property operatorAddresses IP address to use to contact the operator network from this region
 */
public data class PrimaryRegionPropertiesArgs(
    public val allowedMediaSourceAddressPrefixes: Output<List<String>>? = null,
    public val allowedSignalingSourceAddressPrefixes: Output<List<String>>? = null,
    public val esrpAddresses: Output<List<String>>? = null,
    public val operatorAddresses: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.inputs.PrimaryRegionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.inputs.PrimaryRegionPropertiesArgs =
        com.pulumi.azurenative.voiceservices.inputs.PrimaryRegionPropertiesArgs.builder()
            .allowedMediaSourceAddressPrefixes(
                allowedMediaSourceAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .allowedSignalingSourceAddressPrefixes(
                allowedSignalingSourceAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .esrpAddresses(esrpAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .operatorAddresses(operatorAddresses.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrimaryRegionPropertiesArgs].
 */
@PulumiTagMarker
public class PrimaryRegionPropertiesArgsBuilder internal constructor() {
    private var allowedMediaSourceAddressPrefixes: Output<List<String>>? = null

    private var allowedSignalingSourceAddressPrefixes: Output<List<String>>? = null

    private var esrpAddresses: Output<List<String>>? = null

    private var operatorAddresses: Output<List<String>>? = null

    /**
     * @param value The allowed source IP address or CIDR ranges for media
     */
    @JvmName("sdblpvwdrdompfmc")
    public suspend fun allowedMediaSourceAddressPrefixes(`value`: Output<List<String>>) {
        this.allowedMediaSourceAddressPrefixes = value
    }

    @JvmName("mdqwfdasahsclfsd")
    public suspend fun allowedMediaSourceAddressPrefixes(vararg values: Output<String>) {
        this.allowedMediaSourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The allowed source IP address or CIDR ranges for media
     */
    @JvmName("biyrrlnxodcvvdub")
    public suspend fun allowedMediaSourceAddressPrefixes(values: List<Output<String>>) {
        this.allowedMediaSourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The allowed source IP address or CIDR ranges for signaling
     */
    @JvmName("neiuelivkwyafwwj")
    public suspend fun allowedSignalingSourceAddressPrefixes(`value`: Output<List<String>>) {
        this.allowedSignalingSourceAddressPrefixes = value
    }

    @JvmName("vpyjddhvnlolqksn")
    public suspend fun allowedSignalingSourceAddressPrefixes(vararg values: Output<String>) {
        this.allowedSignalingSourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The allowed source IP address or CIDR ranges for signaling
     */
    @JvmName("aardnutvsrrfiqet")
    public suspend fun allowedSignalingSourceAddressPrefixes(values: List<Output<String>>) {
        this.allowedSignalingSourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value IP address to use to contact the ESRP from this region
     */
    @JvmName("orjyvfcakkckqttg")
    public suspend fun esrpAddresses(`value`: Output<List<String>>) {
        this.esrpAddresses = value
    }

    @JvmName("tskbbldxlrymelbr")
    public suspend fun esrpAddresses(vararg values: Output<String>) {
        this.esrpAddresses = Output.all(values.asList())
    }

    /**
     * @param values IP address to use to contact the ESRP from this region
     */
    @JvmName("jfmjyxovmmtfeqgo")
    public suspend fun esrpAddresses(values: List<Output<String>>) {
        this.esrpAddresses = Output.all(values)
    }

    /**
     * @param value IP address to use to contact the operator network from this region
     */
    @JvmName("hcgsvnshprnepldk")
    public suspend fun operatorAddresses(`value`: Output<List<String>>) {
        this.operatorAddresses = value
    }

    @JvmName("kwradkqvygaxixsj")
    public suspend fun operatorAddresses(vararg values: Output<String>) {
        this.operatorAddresses = Output.all(values.asList())
    }

    /**
     * @param values IP address to use to contact the operator network from this region
     */
    @JvmName("xcvtjvpdcrulluks")
    public suspend fun operatorAddresses(values: List<Output<String>>) {
        this.operatorAddresses = Output.all(values)
    }

    /**
     * @param value The allowed source IP address or CIDR ranges for media
     */
    @JvmName("tbryqkqpxloimvyp")
    public suspend fun allowedMediaSourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedMediaSourceAddressPrefixes = mapped
    }

    /**
     * @param values The allowed source IP address or CIDR ranges for media
     */
    @JvmName("bjdkdvvxbnuctleu")
    public suspend fun allowedMediaSourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMediaSourceAddressPrefixes = mapped
    }

    /**
     * @param value The allowed source IP address or CIDR ranges for signaling
     */
    @JvmName("rysagfutqlbefmrc")
    public suspend fun allowedSignalingSourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSignalingSourceAddressPrefixes = mapped
    }

    /**
     * @param values The allowed source IP address or CIDR ranges for signaling
     */
    @JvmName("imsoyqqwarbwacca")
    public suspend fun allowedSignalingSourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedSignalingSourceAddressPrefixes = mapped
    }

    /**
     * @param value IP address to use to contact the ESRP from this region
     */
    @JvmName("wtixohnfqfioxxpv")
    public suspend fun esrpAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.esrpAddresses = mapped
    }

    /**
     * @param values IP address to use to contact the ESRP from this region
     */
    @JvmName("wcjppbvxxhkxvqun")
    public suspend fun esrpAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.esrpAddresses = mapped
    }

    /**
     * @param value IP address to use to contact the operator network from this region
     */
    @JvmName("sqlvbqtcgiisjahu")
    public suspend fun operatorAddresses(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorAddresses = mapped
    }

    /**
     * @param values IP address to use to contact the operator network from this region
     */
    @JvmName("skmcnbccfrpyimfw")
    public suspend fun operatorAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorAddresses = mapped
    }

    internal fun build(): PrimaryRegionPropertiesArgs = PrimaryRegionPropertiesArgs(
        allowedMediaSourceAddressPrefixes = allowedMediaSourceAddressPrefixes,
        allowedSignalingSourceAddressPrefixes = allowedSignalingSourceAddressPrefixes,
        esrpAddresses = esrpAddresses,
        operatorAddresses = operatorAddresses ?: throw PulumiNullFieldException("operatorAddresses"),
    )
}
