@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Contact resource
 * @property contactName Full name of contact
 * @property email Email address of contact
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property phoneNumber Telephone number of contact
 * @property provisioningState Resource provisioning state.
 * @property role Job title of contact
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContactResult(
    public val contactName: String,
    public val email: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val phoneNumber: String,
    public val provisioningState: String,
    public val role: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.GetContactResult): GetContactResult = GetContactResult(
            contactName = javaType.contactName(),
            email = javaType.email(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            phoneNumber = javaType.phoneNumber(),
            provisioningState = javaType.provisioningState(),
            role = javaType.role(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
