@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration used in this region as primary, and other regions as backup.
 * @property allowedMediaSourceAddressPrefixes The allowed source IP address or CIDR ranges for media
 * @property allowedSignalingSourceAddressPrefixes The allowed source IP address or CIDR ranges for signaling
 * @property esrpAddresses IP address to use to contact the ESRP from this region
 * @property operatorAddresses IP address to use to contact the operator network from this region
 */
public data class PrimaryRegionPropertiesResponse(
    public val allowedMediaSourceAddressPrefixes: List<String>? = null,
    public val allowedSignalingSourceAddressPrefixes: List<String>? = null,
    public val esrpAddresses: List<String>? = null,
    public val operatorAddresses: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.PrimaryRegionPropertiesResponse): PrimaryRegionPropertiesResponse = PrimaryRegionPropertiesResponse(
            allowedMediaSourceAddressPrefixes = javaType.allowedMediaSourceAddressPrefixes().map({ args0 ->
                args0
            }),
            allowedSignalingSourceAddressPrefixes = javaType.allowedSignalingSourceAddressPrefixes().map({ args0 ->
                args0
            }),
            esrpAddresses = javaType.esrpAddresses().map({ args0 -> args0 }),
            operatorAddresses = javaType.operatorAddresses().map({ args0 -> args0 }),
        )
    }
}
