@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned identity properties
 * @property clientId The client ID of the assigned identity.
 * @property principalId The principal ID of the assigned identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.voiceservices.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
