@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgs
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Remote Private Endpoint Connection ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01, 2023-12-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceEnvironmentPrivateEndpointConnection = new AzureNative.Web.AppServiceEnvironmentPrivateEndpointConnection("appServiceEnvironmentPrivateEndpointConnection", new()
 *     {
 *         Name = "test-ase",
 *         PrivateEndpointConnectionName = "fa38656c-034e-43d8-adce-fe06ce039c98",
 *         PrivateLinkServiceConnectionState = new AzureNative.Web.Inputs.PrivateLinkConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@company.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServiceEnvironmentPrivateEndpointConnection(ctx, "appServiceEnvironmentPrivateEndpointConnection", &web.AppServiceEnvironmentPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("test-ase"),
 * 			PrivateEndpointConnectionName: pulumi.String("fa38656c-034e-43d8-adce-fe06ce039c98"),
 * 			PrivateLinkServiceConnectionState: &web.PrivateLinkConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@company.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnection;
 * import com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceEnvironmentPrivateEndpointConnection = new AppServiceEnvironmentPrivateEndpointConnection("appServiceEnvironmentPrivateEndpointConnection", AppServiceEnvironmentPrivateEndpointConnectionArgs.builder()
 *             .name("test-ase")
 *             .privateEndpointConnectionName("fa38656c-034e-43d8-adce-fe06ce039c98")
 *             .privateLinkServiceConnectionState(PrivateLinkConnectionStateArgs.builder()
 *                 .description("Approved by johndoe@company.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServiceEnvironmentPrivateEndpointConnection fa38656c-034e-43d8-adce-fe06ce039c98 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property ipAddresses Private IPAddresses mapped to the remote private endpoint
 * @property kind Kind of resource.
 * @property name Name of the App Service Environment.
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState The state of a private link connection
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class AppServiceEnvironmentPrivateEndpointConnectionArgs(
    public val ipAddresses: Output<List<String>>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.web.AppServiceEnvironmentPrivateEndpointConnectionArgs.builder()
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppServiceEnvironmentPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class AppServiceEnvironmentPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var ipAddresses: Output<List<String>>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("drbptwsgslrjfiau")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("nbewhnunrxfxtlhv")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("akybxepeftwgrweb")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("tixmhbbtjnpnucpm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("vdqwjuwrficmgobs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("fgrkewcvqdrflxds")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("skrbiefeyeucemmi")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xpehkaalwquxkitd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("hjwbpboijafbwlcr")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values Private IPAddresses mapped to the remote private endpoint
     */
    @JvmName("gotapkwijwhmquut")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("fnloplyivljwfnno")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("jsibqcflfrxcnvrp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("viwdauewmxgmrvde")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("skhlcbsgaymtrpgg")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The state of a private link connection
     */
    @JvmName("uxapopxiqxofkhth")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ugrojrtnftgwguga")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AppServiceEnvironmentPrivateEndpointConnectionArgs =
        AppServiceEnvironmentPrivateEndpointConnectionArgs(
            ipAddresses = ipAddresses,
            kind = kind,
            name = name,
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
        )
}
