@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse
import com.pulumi.azurenative.web.kotlin.outputs.KubeEnvironmentProfileResponse
import com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.web.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse.Companion.toKotlin as hostingEnvironmentProfileResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.KubeEnvironmentProfileResponse.Companion.toKotlin as kubeEnvironmentProfileResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse.Companion.toKotlin as skuDescriptionResponseToKotlin

/**
 * Builder for [AppServicePlan].
 */
@PulumiTagMarker
public class AppServicePlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppServicePlanArgs = AppServicePlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppServicePlanArgsBuilder.() -> Unit) {
        val builder = AppServicePlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppServicePlan {
        val builtJavaResource = com.pulumi.azurenative.web.AppServicePlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppServicePlan(builtJavaResource)
    }
}

/**
 * App Service plan.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-09-01, 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Example Usage
 * ### Create Or Update App Service plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServicePlan = new AzureNative.Web.AppServicePlan("appServicePlan", new()
 *     {
 *         Kind = "app",
 *         Location = "East US",
 *         Name = "testsf6141",
 *         ResourceGroupName = "testrg123",
 *         Sku = new AzureNative.Web.Inputs.SkuDescriptionArgs
 *         {
 *             Capacity = 1,
 *             Family = "P",
 *             Name = "P1",
 *             Size = "P1",
 *             Tier = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewAppServicePlan(ctx, "appServicePlan", &web.AppServicePlanArgs{
 * 			Kind:              pulumi.String("app"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testsf6141"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Sku: &web.SkuDescriptionArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String("P"),
 * 				Name:     pulumi.String("P1"),
 * 				Size:     pulumi.String("P1"),
 * 				Tier:     pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.AppServicePlan;
 * import com.pulumi.azurenative.web.AppServicePlanArgs;
 * import com.pulumi.azurenative.web.inputs.SkuDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServicePlan = new AppServicePlan("appServicePlan", AppServicePlanArgs.builder()
 *             .kind("app")
 *             .location("East US")
 *             .name("testsf6141")
 *             .resourceGroupName("testrg123")
 *             .sku(SkuDescriptionArgs.builder()
 *                 .capacity(1)
 *                 .family("P")
 *                 .name("P1")
 *                 .size("P1")
 *                 .tier("Premium")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:AppServicePlan testsf6141 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}
 * ```
 */
public class AppServicePlan internal constructor(
    override val javaResource: com.pulumi.azurenative.web.AppServicePlan,
) : KotlinCustomResource(javaResource, AppServicePlanMapper) {
    /**
     * ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
     */
    public val elasticScaleEnabled: Output<Boolean>?
        get() = javaResource.elasticScaleEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The time when the server farm free offer expires.
     */
    public val freeOfferExpirationTime: Output<String>?
        get() = javaResource.freeOfferExpirationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Geographical location for the App Service plan.
     */
    public val geoRegion: Output<String>
        get() = javaResource.geoRegion().applyValue({ args0 -> args0 })

    /**
     * Specification for the App Service Environment to use for the App Service plan.
     */
    public val hostingEnvironmentProfile: Output<HostingEnvironmentProfileResponse>?
        get() = javaResource.hostingEnvironmentProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hostingEnvironmentProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    public val hyperV: Output<Boolean>?
        get() = javaResource.hyperV().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If <code>true</code>, this App Service Plan owns spot instances.
     */
    public val isSpot: Output<Boolean>?
        get() = javaResource.isSpot().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
     */
    public val isXenon: Output<Boolean>?
        get() = javaResource.isXenon().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specification for the Kubernetes Environment to use for the App Service plan.
     */
    public val kubeEnvironmentProfile: Output<KubeEnvironmentProfileResponse>?
        get() = javaResource.kubeEnvironmentProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kubeEnvironmentProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
     */
    public val maximumElasticWorkerCount: Output<Int>?
        get() = javaResource.maximumElasticWorkerCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum number of instances that can be assigned to this App Service plan.
     */
    public val maximumNumberOfWorkers: Output<Int>
        get() = javaResource.maximumNumberOfWorkers().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of apps assigned to this App Service plan.
     */
    public val numberOfSites: Output<Int>
        get() = javaResource.numberOfSites().applyValue({ args0 -> args0 })

    /**
     * The number of instances that are assigned to this App Service plan.
     */
    public val numberOfWorkers: Output<Int>
        get() = javaResource.numberOfWorkers().applyValue({ args0 -> args0 })

    /**
     * If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
     * If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
     */
    public val perSiteScaling: Output<Boolean>?
        get() = javaResource.perSiteScaling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the App Service Plan.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * If Linux app service plan <code>true</code>, <code>false</code> otherwise.
     */
    public val reserved: Output<Boolean>?
        get() = javaResource.reserved().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource group of the App Service plan.
     */
    public val resourceGroup: Output<String>
        get() = javaResource.resourceGroup().applyValue({ args0 -> args0 })

    /**
     * Description of a SKU for a scalable resource.
     */
    public val sku: Output<SkuDescriptionResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time when the server farm expires. Valid only if it is a spot server farm.
     */
    public val spotExpirationTime: Output<String>?
        get() = javaResource.spotExpirationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * App Service plan status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * App Service plan subscription.
     */
    public val subscription: Output<String>
        get() = javaResource.subscription().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Scaling worker count.
     */
    public val targetWorkerCount: Output<Int>?
        get() = javaResource.targetWorkerCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scaling worker size ID.
     */
    public val targetWorkerSizeId: Output<Int>?
        get() = javaResource.targetWorkerSizeId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Target worker tier assigned to the App Service plan.
     */
    public val workerTierName: Output<String>?
        get() = javaResource.workerTierName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If <code>true</code>, this App Service Plan will perform availability zone balancing.
     * If <code>false</code>, this App Service Plan will not perform availability zone balancing.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AppServicePlanMapper : ResourceMapper<AppServicePlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.AppServicePlan::class == javaResource::class

    override fun map(javaResource: Resource): AppServicePlan = AppServicePlan(
        javaResource as
            com.pulumi.azurenative.web.AppServicePlan,
    )
}

/**
 * @see [AppServicePlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppServicePlan].
 */
public suspend fun appServicePlan(
    name: String,
    block: suspend AppServicePlanResourceBuilder.() -> Unit,
): AppServicePlan {
    val builder = AppServicePlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppServicePlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appServicePlan(name: String): AppServicePlan {
    val builder = AppServicePlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
