@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ApiConnectionDefinitionResponseProperties
import com.pulumi.azurenative.web.kotlin.outputs.ApiConnectionDefinitionResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.azurenative.web.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * API connection
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Replace a connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.Web.Connection("connection", new()
 *     {
 *         ConnectionName = "testManagedApi",
 *         Properties = new AzureNative.Web.Inputs.ApiConnectionDefinitionPropertiesArgs
 *         {
 *             Api = new AzureNative.Web.Inputs.ApiReferenceArgs
 *             {
 *                 Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi",
 *             },
 *             CustomParameterValues = null,
 *             DisplayName = "testManagedApi",
 *             ParameterValues = null,
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewConnection(ctx, "connection", &web.ConnectionArgs{
 * 			ConnectionName: pulumi.String("testManagedApi"),
 * 			Properties: &web.ApiConnectionDefinitionPropertiesArgs{
 * 				Api: &web.ApiReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi"),
 * 				},
 * 				CustomParameterValues: nil,
 * 				DisplayName:           pulumi.String("testManagedApi"),
 * 				ParameterValues:       nil,
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.Connection;
 * import com.pulumi.azurenative.web.ConnectionArgs;
 * import com.pulumi.azurenative.web.inputs.ApiConnectionDefinitionPropertiesArgs;
 * import com.pulumi.azurenative.web.inputs.ApiReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .connectionName("testManagedApi")
 *             .properties(ApiConnectionDefinitionPropertiesArgs.builder()
 *                 .api(ApiReferenceArgs.builder()
 *                     .id("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/providers/Microsoft.Web/locations/centralus/managedApis/testManagedApi")
 *                     .build())
 *                 .customParameterValues()
 *                 .displayName("testManagedApi")
 *                 .parameterValues()
 *                 .build())
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:Connection testManagedApi-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * Resource ETag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ApiConnectionDefinitionResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.azurenative.web.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
