@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ConfigurationResponse
import com.pulumi.azurenative.web.kotlin.outputs.TemplateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.web.kotlin.outputs.ConfigurationResponse.Companion.toKotlin as configurationResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.TemplateResponse.Companion.toKotlin as templateResponseToKotlin

/**
 * Builder for [ContainerApp].
 */
@PulumiTagMarker
public class ContainerAppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerAppArgs = ContainerAppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerAppArgsBuilder.() -> Unit) {
        val builder = ContainerAppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContainerApp {
        val builtJavaResource = com.pulumi.azurenative.web.ContainerApp(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContainerApp(builtJavaResource)
    }
}

/**
 * Container App.
 * Azure REST API version: 2023-01-01.
 * Other available API versions: 2023-12-01.
 * ## Example Usage
 * ### Create or Update Container App
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerApp = new AzureNative.Web.ContainerApp("containerApp", new()
 *     {
 *         Configuration = new AzureNative.Web.Inputs.ConfigurationArgs
 *         {
 *             Ingress = new AzureNative.Web.Inputs.IngressArgs
 *             {
 *                 External = true,
 *                 TargetPort = 3000,
 *             },
 *         },
 *         Kind = "containerApp",
 *         KubeEnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube",
 *         Location = "East US",
 *         Name = "testcontainerApp0",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.Web.Inputs.TemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.Web.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerApp0:v1",
 *                     Name = "testcontainerApp0",
 *                 },
 *             },
 *             Dapr = new AzureNative.Web.Inputs.DaprArgs
 *             {
 *                 AppPort = 3000,
 *                 Enabled = true,
 *             },
 *             Scale = new AzureNative.Web.Inputs.ScaleArgs
 *             {
 *                 MaxReplicas = 5,
 *                 MinReplicas = 1,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Web.Inputs.ScaleRuleArgs
 *                     {
 *                         Custom = new AzureNative.Web.Inputs.CustomScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "concurrentRequests", "50" },
 *                             },
 *                             Type = "http",
 *                         },
 *                         Name = "httpscalingrule",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewContainerApp(ctx, "containerApp", &web.ContainerAppArgs{
 * 			Configuration: &web.ConfigurationArgs{
 * 				Ingress: &web.IngressArgs{
 * 					External:   pulumi.Bool(true),
 * 					TargetPort: pulumi.Int(3000),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("containerApp"),
 * 			KubeEnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testcontainerApp0"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Template: &web.TemplateArgs{
 * 				Containers: web.ContainerArray{
 * 					&web.ContainerArgs{
 * 						Image: pulumi.String("repo/testcontainerApp0:v1"),
 * 						Name:  pulumi.String("testcontainerApp0"),
 * 					},
 * 				},
 * 				Dapr: &web.DaprArgs{
 * 					AppPort: pulumi.Int(3000),
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Scale: &web.ScaleArgs{
 * 					MaxReplicas: pulumi.Int(5),
 * 					MinReplicas: pulumi.Int(1),
 * 					Rules: web.ScaleRuleArray{
 * 						&web.ScaleRuleArgs{
 * 							Custom: &web.CustomScaleRuleArgs{
 * 								Metadata: pulumi.StringMap{
 * 									"concurrentRequests": pulumi.String("50"),
 * 								},
 * 								Type: pulumi.String("http"),
 * 							},
 * 							Name: pulumi.String("httpscalingrule"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.ContainerApp;
 * import com.pulumi.azurenative.web.ContainerAppArgs;
 * import com.pulumi.azurenative.web.inputs.ConfigurationArgs;
 * import com.pulumi.azurenative.web.inputs.IngressArgs;
 * import com.pulumi.azurenative.web.inputs.TemplateArgs;
 * import com.pulumi.azurenative.web.inputs.DaprArgs;
 * import com.pulumi.azurenative.web.inputs.ScaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerApp = new ContainerApp("containerApp", ContainerAppArgs.builder()
 *             .configuration(ConfigurationArgs.builder()
 *                 .ingress(IngressArgs.builder()
 *                     .external(true)
 *                     .targetPort(3000)
 *                     .build())
 *                 .build())
 *             .kind("containerApp")
 *             .kubeEnvironmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube")
 *             .location("East US")
 *             .name("testcontainerApp0")
 *             .resourceGroupName("rg")
 *             .template(TemplateArgs.builder()
 *                 .containers(ContainerArgs.builder()
 *                     .image("repo/testcontainerApp0:v1")
 *                     .name("testcontainerApp0")
 *                     .build())
 *                 .dapr(DaprArgs.builder()
 *                     .appPort(3000)
 *                     .enabled(true)
 *                     .build())
 *                 .scale(ScaleArgs.builder()
 *                     .maxReplicas(5)
 *                     .minReplicas(1)
 *                     .rules(ScaleRuleArgs.builder()
 *                         .custom(CustomScaleRuleArgs.builder()
 *                             .metadata(Map.of("concurrentRequests", "50"))
 *                             .type("http")
 *                             .build())
 *                         .name("httpscalingrule")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:ContainerApp testcontainerApp0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{name}
 * ```
 */
public class ContainerApp internal constructor(
    override val javaResource: com.pulumi.azurenative.web.ContainerApp,
) : KotlinCustomResource(javaResource, ContainerAppMapper) {
    /**
     * Non versioned Container App configuration properties.
     */
    public val configuration: Output<ConfigurationResponse>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource ID of the Container App's KubeEnvironment.
     */
    public val kubeEnvironmentId: Output<String>?
        get() = javaResource.kubeEnvironmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Fully Qualified Domain Name of the latest revision of the Container App.
     */
    public val latestRevisionFqdn: Output<String>
        get() = javaResource.latestRevisionFqdn().applyValue({ args0 -> args0 })

    /**
     * Name of the latest revision of the Container App.
     */
    public val latestRevisionName: Output<String>
        get() = javaResource.latestRevisionName().applyValue({ args0 -> args0 })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Container App.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Container App versioned application definition.
     */
    public val template: Output<TemplateResponse>?
        get() = javaResource.template().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    templateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContainerAppMapper : ResourceMapper<ContainerApp> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.ContainerApp::class == javaResource::class

    override fun map(javaResource: Resource): ContainerApp = ContainerApp(
        javaResource as
            com.pulumi.azurenative.web.ContainerApp,
    )
}

/**
 * @see [ContainerApp].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerApp].
 */
public suspend fun containerApp(
    name: String,
    block: suspend ContainerAppResourceBuilder.() -> Unit,
): ContainerApp {
    val builder = ContainerAppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerApp].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerApp(name: String): ContainerApp {
    val builder = ContainerAppResourceBuilder()
    builder.name(name)
    return builder.build()
}
