@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppAuthSettingsSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.BuiltInAuthenticationProvider
import com.pulumi.azurenative.web.kotlin.enums.UnauthenticatedClientAction
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration settings for the Azure App Service Authentication / Authorization feature.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAuthSettingsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings
 * ```
 * @property aadClaimsAuthorization Gets a JSON string containing the Azure AD Acl settings.
 * @property additionalLoginParams Login parameters to send to the OpenID Connect authorization endpoint when
 * a user logs in. Each parameter must be in the form "key=value".
 * @property allowedAudiences Allowed audience values to consider when validating JSON Web Tokens issued by
 * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
 * allowed audience, regardless of this setting.
 * @property allowedExternalRedirectUrls External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
 * This is an advanced setting typically only needed by Windows Store application backends.
 * Note that URLs within the current domain are always implicitly allowed.
 * @property authFilePath The path of the config file containing auth settings.
 * If the path is relative, base will the site's root directory.
 * @property clientId The Client ID of this relying party application, known as the client_id.
 * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
 * other 3rd party OpenID Connect providers.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecret The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
 * This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
 * Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecretCertificateThumbprint An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret. It is also optional.
 * @property clientSecretSettingName The app setting name that contains the client secret of the relying party application.
 * @property configVersion The ConfigVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of the control plane for Authentication / Authorization.
 * @property defaultProvider The default authentication provider to use when multiple providers are configured.
 * This setting is only needed if multiple providers are configured and the unauthenticated client
 * action is set to "RedirectToLoginPage".
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property facebookAppId The App ID of the Facebook app used for login.
 * This setting is required for enabling Facebook Login.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property facebookAppSecret The App Secret of the Facebook app used for Facebook Login.
 * This setting is required for enabling Facebook Login.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property facebookAppSecretSettingName The app setting name that contains the app secret used for Facebook Login.
 * @property facebookOAuthScopes The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
 * This setting is optional.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property gitHubClientId The Client Id of the GitHub app used for login.
 * This setting is required for enabling Github login
 * @property gitHubClientSecret The Client Secret of the GitHub app used for Github Login.
 * This setting is required for enabling Github login.
 * @property gitHubClientSecretSettingName The app setting name that contains the client secret of the Github
 * app used for GitHub Login.
 * @property gitHubOAuthScopes The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
 * This setting is optional
 * @property googleClientId The OpenID Connect Client ID for the Google web application.
 * This setting is required for enabling Google Sign-In.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property googleClientSecret The client secret associated with the Google web application.
 * This setting is required for enabling Google Sign-In.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property googleClientSecretSettingName The app setting name that contains the client secret associated with
 * the Google web application.
 * @property googleOAuthScopes The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
 * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property isAuthFromFile "true" if the auth config settings should be read from a file,
 * "false" otherwise
 * @property issuer The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
 * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
 * This URI is a case-sensitive identifier for the token issuer.
 * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
 * @property kind Kind of resource.
 * @property microsoftAccountClientId The OAuth 2.0 client ID that was created for the app used for authentication.
 * This setting is required for enabling Microsoft Account authentication.
 * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
 * @property microsoftAccountClientSecret The OAuth 2.0 client secret that was created for the app used for authentication.
 * This setting is required for enabling Microsoft Account authentication.
 * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
 * @property microsoftAccountClientSecretSettingName The app setting name containing the OAuth 2.0 client secret that was created for the
 * app used for authentication.
 * @property microsoftAccountOAuthScopes The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
 * This setting is optional. If not specified, "wl.basic" is used as the default scope.
 * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
 * @property name Name of web app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 * @property slot Name of web app slot. If not specified then will default to production slot.
 * @property tokenRefreshExtensionHours The number of hours after session token expiration that a session token can be used to
 * call the token refresh API. The default is 72 hours.
 * @property tokenStoreEnabled <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
 *  The default is <code>false</code>.
 * @property twitterConsumerKey The OAuth 1.0a consumer key of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property twitterConsumerSecret The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property twitterConsumerSecretSettingName The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
 * application used for sign-in.
 * @property unauthenticatedClientAction The action to take when an unauthenticated client attempts to access the app.
 * @property validateIssuer Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
 */
public data class WebAppAuthSettingsSlotArgs(
    public val aadClaimsAuthorization: Output<String>? = null,
    public val additionalLoginParams: Output<List<String>>? = null,
    public val allowedAudiences: Output<List<String>>? = null,
    public val allowedExternalRedirectUrls: Output<List<String>>? = null,
    public val authFilePath: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val clientSecretCertificateThumbprint: Output<String>? = null,
    public val clientSecretSettingName: Output<String>? = null,
    public val configVersion: Output<String>? = null,
    public val defaultProvider: Output<BuiltInAuthenticationProvider>? = null,
    public val enabled: Output<Boolean>? = null,
    public val facebookAppId: Output<String>? = null,
    public val facebookAppSecret: Output<String>? = null,
    public val facebookAppSecretSettingName: Output<String>? = null,
    public val facebookOAuthScopes: Output<List<String>>? = null,
    public val gitHubClientId: Output<String>? = null,
    public val gitHubClientSecret: Output<String>? = null,
    public val gitHubClientSecretSettingName: Output<String>? = null,
    public val gitHubOAuthScopes: Output<List<String>>? = null,
    public val googleClientId: Output<String>? = null,
    public val googleClientSecret: Output<String>? = null,
    public val googleClientSecretSettingName: Output<String>? = null,
    public val googleOAuthScopes: Output<List<String>>? = null,
    public val isAuthFromFile: Output<String>? = null,
    public val issuer: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val microsoftAccountClientId: Output<String>? = null,
    public val microsoftAccountClientSecret: Output<String>? = null,
    public val microsoftAccountClientSecretSettingName: Output<String>? = null,
    public val microsoftAccountOAuthScopes: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val tokenRefreshExtensionHours: Output<Double>? = null,
    public val tokenStoreEnabled: Output<Boolean>? = null,
    public val twitterConsumerKey: Output<String>? = null,
    public val twitterConsumerSecret: Output<String>? = null,
    public val twitterConsumerSecretSettingName: Output<String>? = null,
    public val unauthenticatedClientAction: Output<UnauthenticatedClientAction>? = null,
    public val validateIssuer: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppAuthSettingsSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppAuthSettingsSlotArgs =
        com.pulumi.azurenative.web.WebAppAuthSettingsSlotArgs.builder()
            .aadClaimsAuthorization(aadClaimsAuthorization?.applyValue({ args0 -> args0 }))
            .additionalLoginParams(additionalLoginParams?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedAudiences(allowedAudiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedExternalRedirectUrls(
                allowedExternalRedirectUrls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .authFilePath(authFilePath?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .clientSecretCertificateThumbprint(
                clientSecretCertificateThumbprint?.applyValue({ args0 ->
                    args0
                }),
            )
            .clientSecretSettingName(clientSecretSettingName?.applyValue({ args0 -> args0 }))
            .configVersion(configVersion?.applyValue({ args0 -> args0 }))
            .defaultProvider(defaultProvider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .facebookAppId(facebookAppId?.applyValue({ args0 -> args0 }))
            .facebookAppSecret(facebookAppSecret?.applyValue({ args0 -> args0 }))
            .facebookAppSecretSettingName(facebookAppSecretSettingName?.applyValue({ args0 -> args0 }))
            .facebookOAuthScopes(facebookOAuthScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gitHubClientId(gitHubClientId?.applyValue({ args0 -> args0 }))
            .gitHubClientSecret(gitHubClientSecret?.applyValue({ args0 -> args0 }))
            .gitHubClientSecretSettingName(gitHubClientSecretSettingName?.applyValue({ args0 -> args0 }))
            .gitHubOAuthScopes(gitHubOAuthScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .googleClientId(googleClientId?.applyValue({ args0 -> args0 }))
            .googleClientSecret(googleClientSecret?.applyValue({ args0 -> args0 }))
            .googleClientSecretSettingName(googleClientSecretSettingName?.applyValue({ args0 -> args0 }))
            .googleOAuthScopes(googleOAuthScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isAuthFromFile(isAuthFromFile?.applyValue({ args0 -> args0 }))
            .issuer(issuer?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .microsoftAccountClientId(microsoftAccountClientId?.applyValue({ args0 -> args0 }))
            .microsoftAccountClientSecret(microsoftAccountClientSecret?.applyValue({ args0 -> args0 }))
            .microsoftAccountClientSecretSettingName(
                microsoftAccountClientSecretSettingName?.applyValue({ args0 ->
                    args0
                }),
            )
            .microsoftAccountOAuthScopes(
                microsoftAccountOAuthScopes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .tokenRefreshExtensionHours(tokenRefreshExtensionHours?.applyValue({ args0 -> args0 }))
            .tokenStoreEnabled(tokenStoreEnabled?.applyValue({ args0 -> args0 }))
            .twitterConsumerKey(twitterConsumerKey?.applyValue({ args0 -> args0 }))
            .twitterConsumerSecret(twitterConsumerSecret?.applyValue({ args0 -> args0 }))
            .twitterConsumerSecretSettingName(twitterConsumerSecretSettingName?.applyValue({ args0 -> args0 }))
            .unauthenticatedClientAction(
                unauthenticatedClientAction?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validateIssuer(validateIssuer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppAuthSettingsSlotArgs].
 */
@PulumiTagMarker
public class WebAppAuthSettingsSlotArgsBuilder internal constructor() {
    private var aadClaimsAuthorization: Output<String>? = null

    private var additionalLoginParams: Output<List<String>>? = null

    private var allowedAudiences: Output<List<String>>? = null

    private var allowedExternalRedirectUrls: Output<List<String>>? = null

    private var authFilePath: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var clientSecretCertificateThumbprint: Output<String>? = null

    private var clientSecretSettingName: Output<String>? = null

    private var configVersion: Output<String>? = null

    private var defaultProvider: Output<BuiltInAuthenticationProvider>? = null

    private var enabled: Output<Boolean>? = null

    private var facebookAppId: Output<String>? = null

    private var facebookAppSecret: Output<String>? = null

    private var facebookAppSecretSettingName: Output<String>? = null

    private var facebookOAuthScopes: Output<List<String>>? = null

    private var gitHubClientId: Output<String>? = null

    private var gitHubClientSecret: Output<String>? = null

    private var gitHubClientSecretSettingName: Output<String>? = null

    private var gitHubOAuthScopes: Output<List<String>>? = null

    private var googleClientId: Output<String>? = null

    private var googleClientSecret: Output<String>? = null

    private var googleClientSecretSettingName: Output<String>? = null

    private var googleOAuthScopes: Output<List<String>>? = null

    private var isAuthFromFile: Output<String>? = null

    private var issuer: Output<String>? = null

    private var kind: Output<String>? = null

    private var microsoftAccountClientId: Output<String>? = null

    private var microsoftAccountClientSecret: Output<String>? = null

    private var microsoftAccountClientSecretSettingName: Output<String>? = null

    private var microsoftAccountOAuthScopes: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var slot: Output<String>? = null

    private var tokenRefreshExtensionHours: Output<Double>? = null

    private var tokenStoreEnabled: Output<Boolean>? = null

    private var twitterConsumerKey: Output<String>? = null

    private var twitterConsumerSecret: Output<String>? = null

    private var twitterConsumerSecretSettingName: Output<String>? = null

    private var unauthenticatedClientAction: Output<UnauthenticatedClientAction>? = null

    private var validateIssuer: Output<Boolean>? = null

    /**
     * @param value Gets a JSON string containing the Azure AD Acl settings.
     */
    @JvmName("asdcypkhvgrcqfgd")
    public suspend fun aadClaimsAuthorization(`value`: Output<String>) {
        this.aadClaimsAuthorization = value
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("dekawogmhhdiwwri")
    public suspend fun additionalLoginParams(`value`: Output<List<String>>) {
        this.additionalLoginParams = value
    }

    @JvmName("tuyudowlqxylreok")
    public suspend fun additionalLoginParams(vararg values: Output<String>) {
        this.additionalLoginParams = Output.all(values.asList())
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("ugvndtobebuytoat")
    public suspend fun additionalLoginParams(values: List<Output<String>>) {
        this.additionalLoginParams = Output.all(values)
    }

    /**
     * @param value Allowed audience values to consider when validating JSON Web Tokens issued by
     * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
     * allowed audience, regardless of this setting.
     */
    @JvmName("jqvhsgyaevydrwwu")
    public suspend fun allowedAudiences(`value`: Output<List<String>>) {
        this.allowedAudiences = value
    }

    @JvmName("wdwdrruxrugtykgi")
    public suspend fun allowedAudiences(vararg values: Output<String>) {
        this.allowedAudiences = Output.all(values.asList())
    }

    /**
     * @param values Allowed audience values to consider when validating JSON Web Tokens issued by
     * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
     * allowed audience, regardless of this setting.
     */
    @JvmName("yxkgmjmjqbybmmll")
    public suspend fun allowedAudiences(values: List<Output<String>>) {
        this.allowedAudiences = Output.all(values)
    }

    /**
     * @param value External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("dmgotvporsitrtuh")
    public suspend fun allowedExternalRedirectUrls(`value`: Output<List<String>>) {
        this.allowedExternalRedirectUrls = value
    }

    @JvmName("rmhjhbldyryiktrx")
    public suspend fun allowedExternalRedirectUrls(vararg values: Output<String>) {
        this.allowedExternalRedirectUrls = Output.all(values.asList())
    }

    /**
     * @param values External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("xerqysmvqpxvuchc")
    public suspend fun allowedExternalRedirectUrls(values: List<Output<String>>) {
        this.allowedExternalRedirectUrls = Output.all(values)
    }

    /**
     * @param value The path of the config file containing auth settings.
     * If the path is relative, base will the site's root directory.
     */
    @JvmName("bdwomegbltnpoaaw")
    public suspend fun authFilePath(`value`: Output<String>) {
        this.authFilePath = value
    }

    /**
     * @param value The Client ID of this relying party application, known as the client_id.
     * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
     * other 3rd party OpenID Connect providers.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("jugsufhvaqqrrwcq")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
     * This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
     * Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("ukfuhstvsqiklapn")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret. It is also optional.
     */
    @JvmName("riagguvmpvcrbxxm")
    public suspend fun clientSecretCertificateThumbprint(`value`: Output<String>) {
        this.clientSecretCertificateThumbprint = value
    }

    /**
     * @param value The app setting name that contains the client secret of the relying party application.
     */
    @JvmName("vojhedhwhcgmgjbm")
    public suspend fun clientSecretSettingName(`value`: Output<String>) {
        this.clientSecretSettingName = value
    }

    /**
     * @param value The ConfigVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of the control plane for Authentication / Authorization.
     */
    @JvmName("nfmmvnrhnommqeae")
    public suspend fun configVersion(`value`: Output<String>) {
        this.configVersion = value
    }

    /**
     * @param value The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    @JvmName("pswgouhjdyobtvxd")
    public suspend fun defaultProvider(`value`: Output<BuiltInAuthenticationProvider>) {
        this.defaultProvider = value
    }

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("dtvgofpptcwykkec")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The App ID of the Facebook app used for login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("bcyrumsejmukxoyc")
    public suspend fun facebookAppId(`value`: Output<String>) {
        this.facebookAppId = value
    }

    /**
     * @param value The App Secret of the Facebook app used for Facebook Login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("bxpgkwybpdfhgklv")
    public suspend fun facebookAppSecret(`value`: Output<String>) {
        this.facebookAppSecret = value
    }

    /**
     * @param value The app setting name that contains the app secret used for Facebook Login.
     */
    @JvmName("omsykvihyeabksjl")
    public suspend fun facebookAppSecretSettingName(`value`: Output<String>) {
        this.facebookAppSecretSettingName = value
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
     * This setting is optional.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("mlbskeoxclfvaefm")
    public suspend fun facebookOAuthScopes(`value`: Output<List<String>>) {
        this.facebookOAuthScopes = value
    }

    @JvmName("hahlxepvewsbujce")
    public suspend fun facebookOAuthScopes(vararg values: Output<String>) {
        this.facebookOAuthScopes = Output.all(values.asList())
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
     * This setting is optional.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("hugmglrchgyxkinp")
    public suspend fun facebookOAuthScopes(values: List<Output<String>>) {
        this.facebookOAuthScopes = Output.all(values)
    }

    /**
     * @param value The Client Id of the GitHub app used for login.
     * This setting is required for enabling Github login
     */
    @JvmName("ehmtkowhqugrwceh")
    public suspend fun gitHubClientId(`value`: Output<String>) {
        this.gitHubClientId = value
    }

    /**
     * @param value The Client Secret of the GitHub app used for Github Login.
     * This setting is required for enabling Github login.
     */
    @JvmName("ayaxhjbsqsngnqqi")
    public suspend fun gitHubClientSecret(`value`: Output<String>) {
        this.gitHubClientSecret = value
    }

    /**
     * @param value The app setting name that contains the client secret of the Github
     * app used for GitHub Login.
     */
    @JvmName("ygjukisxwqkbjnsx")
    public suspend fun gitHubClientSecretSettingName(`value`: Output<String>) {
        this.gitHubClientSecretSettingName = value
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
     * This setting is optional
     */
    @JvmName("akbtepovwwppqjua")
    public suspend fun gitHubOAuthScopes(`value`: Output<List<String>>) {
        this.gitHubOAuthScopes = value
    }

    @JvmName("hhbhcsgbfuonmkwx")
    public suspend fun gitHubOAuthScopes(vararg values: Output<String>) {
        this.gitHubOAuthScopes = Output.all(values.asList())
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
     * This setting is optional
     */
    @JvmName("nnxmmhhlqhcqpnft")
    public suspend fun gitHubOAuthScopes(values: List<Output<String>>) {
        this.gitHubOAuthScopes = Output.all(values)
    }

    /**
     * @param value The OpenID Connect Client ID for the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("tpjtcxoyxkgridue")
    public suspend fun googleClientId(`value`: Output<String>) {
        this.googleClientId = value
    }

    /**
     * @param value The client secret associated with the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("okumycesrsamdvix")
    public suspend fun googleClientSecret(`value`: Output<String>) {
        this.googleClientSecret = value
    }

    /**
     * @param value The app setting name that contains the client secret associated with
     * the Google web application.
     */
    @JvmName("ufujuqcbmpckjdyh")
    public suspend fun googleClientSecretSettingName(`value`: Output<String>) {
        this.googleClientSecretSettingName = value
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
     * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("dgdhumwwgekdgiou")
    public suspend fun googleOAuthScopes(`value`: Output<List<String>>) {
        this.googleOAuthScopes = value
    }

    @JvmName("jfenmiysagwqtkkk")
    public suspend fun googleOAuthScopes(vararg values: Output<String>) {
        this.googleOAuthScopes = Output.all(values.asList())
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
     * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("rfslhcpsshrqhxcw")
    public suspend fun googleOAuthScopes(values: List<Output<String>>) {
        this.googleOAuthScopes = Output.all(values)
    }

    /**
     * @param value "true" if the auth config settings should be read from a file,
     * "false" otherwise
     */
    @JvmName("feopnlslwcjatuwn")
    public suspend fun isAuthFromFile(`value`: Output<String>) {
        this.isAuthFromFile = value
    }

    /**
     * @param value The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
     * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
     * This URI is a case-sensitive identifier for the token issuer.
     * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
     */
    @JvmName("vmpbubwsiqyitumw")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ubmmwcsclfdnknmo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The OAuth 2.0 client ID that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    @JvmName("jvdoqcijfysytujr")
    public suspend fun microsoftAccountClientId(`value`: Output<String>) {
        this.microsoftAccountClientId = value
    }

    /**
     * @param value The OAuth 2.0 client secret that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    @JvmName("auleaairlbenhpst")
    public suspend fun microsoftAccountClientSecret(`value`: Output<String>) {
        this.microsoftAccountClientSecret = value
    }

    /**
     * @param value The app setting name containing the OAuth 2.0 client secret that was created for the
     * app used for authentication.
     */
    @JvmName("dransfekrbruyxqx")
    public suspend fun microsoftAccountClientSecretSettingName(`value`: Output<String>) {
        this.microsoftAccountClientSecretSettingName = value
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
     * This setting is optional. If not specified, "wl.basic" is used as the default scope.
     * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
     */
    @JvmName("kwxrwkfpbtlbjrbr")
    public suspend fun microsoftAccountOAuthScopes(`value`: Output<List<String>>) {
        this.microsoftAccountOAuthScopes = value
    }

    @JvmName("fweyuniesmfqjyrc")
    public suspend fun microsoftAccountOAuthScopes(vararg values: Output<String>) {
        this.microsoftAccountOAuthScopes = Output.all(values.asList())
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
     * This setting is optional. If not specified, "wl.basic" is used as the default scope.
     * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
     */
    @JvmName("sfmeyenxtdavseoi")
    public suspend fun microsoftAccountOAuthScopes(values: List<Output<String>>) {
        this.microsoftAccountOAuthScopes = Output.all(values)
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("ncqugclhvtixitwl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("jgtmwvmbovohiurt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("clfpkexmgbpeccki")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("cqwbqlqvkpeiqhgl")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    @JvmName("xqtbjkjdmnyqfird")
    public suspend fun tokenRefreshExtensionHours(`value`: Output<Double>) {
        this.tokenRefreshExtensionHours = value
    }

    /**
     * @param value <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
     *  The default is <code>false</code>.
     */
    @JvmName("drkpbwxdoyrkbdjj")
    public suspend fun tokenStoreEnabled(`value`: Output<Boolean>) {
        this.tokenStoreEnabled = value
    }

    /**
     * @param value The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("ykaomdrkhhdmpvpn")
    public suspend fun twitterConsumerKey(`value`: Output<String>) {
        this.twitterConsumerKey = value
    }

    /**
     * @param value The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("noqkvttapljlxpws")
    public suspend fun twitterConsumerSecret(`value`: Output<String>) {
        this.twitterConsumerSecret = value
    }

    /**
     * @param value The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    @JvmName("kaypeowtfhuqshvn")
    public suspend fun twitterConsumerSecretSettingName(`value`: Output<String>) {
        this.twitterConsumerSecretSettingName = value
    }

    /**
     * @param value The action to take when an unauthenticated client attempts to access the app.
     */
    @JvmName("qfqyueeegaiqgexo")
    public suspend fun unauthenticatedClientAction(`value`: Output<UnauthenticatedClientAction>) {
        this.unauthenticatedClientAction = value
    }

    /**
     * @param value Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
     */
    @JvmName("otvcdwcssfnjicba")
    public suspend fun validateIssuer(`value`: Output<Boolean>) {
        this.validateIssuer = value
    }

    /**
     * @param value Gets a JSON string containing the Azure AD Acl settings.
     */
    @JvmName("chthahnjmgclvwwa")
    public suspend fun aadClaimsAuthorization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadClaimsAuthorization = mapped
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("ldyexxfivtltvyyq")
    public suspend fun additionalLoginParams(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLoginParams = mapped
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("vyljhtqrtwicapgt")
    public suspend fun additionalLoginParams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalLoginParams = mapped
    }

    /**
     * @param value Allowed audience values to consider when validating JSON Web Tokens issued by
     * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
     * allowed audience, regardless of this setting.
     */
    @JvmName("malrbrakckyylidi")
    public suspend fun allowedAudiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param values Allowed audience values to consider when validating JSON Web Tokens issued by
     * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
     * allowed audience, regardless of this setting.
     */
    @JvmName("gccvlhwladikpuys")
    public suspend fun allowedAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param value External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("lmlmwqxehsdlrudw")
    public suspend fun allowedExternalRedirectUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedExternalRedirectUrls = mapped
    }

    /**
     * @param values External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("afngqnfreqqshmal")
    public suspend fun allowedExternalRedirectUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedExternalRedirectUrls = mapped
    }

    /**
     * @param value The path of the config file containing auth settings.
     * If the path is relative, base will the site's root directory.
     */
    @JvmName("eshkfbsnglxhrmpg")
    public suspend fun authFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authFilePath = mapped
    }

    /**
     * @param value The Client ID of this relying party application, known as the client_id.
     * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
     * other 3rd party OpenID Connect providers.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("alhrqlnpxgtheixx")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
     * This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
     * Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("hmwpqnrchrpwxnnl")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret. It is also optional.
     */
    @JvmName("qrjcxqaaehwlnkpx")
    public suspend fun clientSecretCertificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretCertificateThumbprint = mapped
    }

    /**
     * @param value The app setting name that contains the client secret of the relying party application.
     */
    @JvmName("xhlasottuyfieynx")
    public suspend fun clientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretSettingName = mapped
    }

    /**
     * @param value The ConfigVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of the control plane for Authentication / Authorization.
     */
    @JvmName("fxiswxmonhquqkwo")
    public suspend fun configVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configVersion = mapped
    }

    /**
     * @param value The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    @JvmName("otbyayglpawalmbn")
    public suspend fun defaultProvider(`value`: BuiltInAuthenticationProvider?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultProvider = mapped
    }

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("cvrooypachqrpsaq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The App ID of the Facebook app used for login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("yhtbxuarweasldrh")
    public suspend fun facebookAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facebookAppId = mapped
    }

    /**
     * @param value The App Secret of the Facebook app used for Facebook Login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("tklpkfvbityddkvt")
    public suspend fun facebookAppSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facebookAppSecret = mapped
    }

    /**
     * @param value The app setting name that contains the app secret used for Facebook Login.
     */
    @JvmName("spumulrrkoddpqxn")
    public suspend fun facebookAppSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facebookAppSecretSettingName = mapped
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
     * This setting is optional.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("lvlfikrbbovomexj")
    public suspend fun facebookOAuthScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facebookOAuthScopes = mapped
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
     * This setting is optional.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    @JvmName("nmhdpedukgimrqnf")
    public suspend fun facebookOAuthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.facebookOAuthScopes = mapped
    }

    /**
     * @param value The Client Id of the GitHub app used for login.
     * This setting is required for enabling Github login
     */
    @JvmName("cojpgfchnxugtwhp")
    public suspend fun gitHubClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubClientId = mapped
    }

    /**
     * @param value The Client Secret of the GitHub app used for Github Login.
     * This setting is required for enabling Github login.
     */
    @JvmName("vxpoasnxevaelfcb")
    public suspend fun gitHubClientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubClientSecret = mapped
    }

    /**
     * @param value The app setting name that contains the client secret of the Github
     * app used for GitHub Login.
     */
    @JvmName("rkgunbxxxqhaojbr")
    public suspend fun gitHubClientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubClientSecretSettingName = mapped
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
     * This setting is optional
     */
    @JvmName("wtfequjiwxqxbxkw")
    public suspend fun gitHubOAuthScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubOAuthScopes = mapped
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
     * This setting is optional
     */
    @JvmName("qushpbkrxbkmvykg")
    public suspend fun gitHubOAuthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitHubOAuthScopes = mapped
    }

    /**
     * @param value The OpenID Connect Client ID for the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("fikxcnbfcwoidgrs")
    public suspend fun googleClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleClientId = mapped
    }

    /**
     * @param value The client secret associated with the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("mvayjbgnnxaggddc")
    public suspend fun googleClientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleClientSecret = mapped
    }

    /**
     * @param value The app setting name that contains the client secret associated with
     * the Google web application.
     */
    @JvmName("rnxoyhxgoemjpvvh")
    public suspend fun googleClientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleClientSecretSettingName = mapped
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
     * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("ejdbbnfvsssctcka")
    public suspend fun googleOAuthScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleOAuthScopes = mapped
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
     * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    @JvmName("foaphoqitcekeqar")
    public suspend fun googleOAuthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.googleOAuthScopes = mapped
    }

    /**
     * @param value "true" if the auth config settings should be read from a file,
     * "false" otherwise
     */
    @JvmName("nfnwfvgsamqqxism")
    public suspend fun isAuthFromFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAuthFromFile = mapped
    }

    /**
     * @param value The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
     * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
     * This URI is a case-sensitive identifier for the token issuer.
     * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
     */
    @JvmName("ctnqfwdypvkscpmf")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("fiutjxqpcbtslwxn")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The OAuth 2.0 client ID that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    @JvmName("uelxvgktxpsyqbeo")
    public suspend fun microsoftAccountClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftAccountClientId = mapped
    }

    /**
     * @param value The OAuth 2.0 client secret that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    @JvmName("qocqccpcsjynhpwf")
    public suspend fun microsoftAccountClientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftAccountClientSecret = mapped
    }

    /**
     * @param value The app setting name containing the OAuth 2.0 client secret that was created for the
     * app used for authentication.
     */
    @JvmName("gyenhryfgolwcmex")
    public suspend fun microsoftAccountClientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftAccountClientSecretSettingName = mapped
    }

    /**
     * @param value The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
     * This setting is optional. If not specified, "wl.basic" is used as the default scope.
     * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
     */
    @JvmName("xbkjxhjbkgpuquqd")
    public suspend fun microsoftAccountOAuthScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microsoftAccountOAuthScopes = mapped
    }

    /**
     * @param values The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
     * This setting is optional. If not specified, "wl.basic" is used as the default scope.
     * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
     */
    @JvmName("crspxigktwybnwpb")
    public suspend fun microsoftAccountOAuthScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.microsoftAccountOAuthScopes = mapped
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("csjvpsrgugwivccs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("louqytojlduomqjf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("lqqwtklpcehexyug")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("oiubkfvwoijypoub")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    @JvmName("usjbsrvijqunvysu")
    public suspend fun tokenRefreshExtensionHours(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenRefreshExtensionHours = mapped
    }

    /**
     * @param value <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
     *  The default is <code>false</code>.
     */
    @JvmName("uvyqsrkhqrjmtpqa")
    public suspend fun tokenStoreEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenStoreEnabled = mapped
    }

    /**
     * @param value The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("cppqlhylcixbqlfl")
    public suspend fun twitterConsumerKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twitterConsumerKey = mapped
    }

    /**
     * @param value The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    @JvmName("elabntxwgxolhped")
    public suspend fun twitterConsumerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twitterConsumerSecret = mapped
    }

    /**
     * @param value The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    @JvmName("byfpwuurqvmchbha")
    public suspend fun twitterConsumerSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twitterConsumerSecretSettingName = mapped
    }

    /**
     * @param value The action to take when an unauthenticated client attempts to access the app.
     */
    @JvmName("sloxhhvqcweattab")
    public suspend fun unauthenticatedClientAction(`value`: UnauthenticatedClientAction?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unauthenticatedClientAction = mapped
    }

    /**
     * @param value Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
     */
    @JvmName("kscltxobdrpvuecd")
    public suspend fun validateIssuer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateIssuer = mapped
    }

    internal fun build(): WebAppAuthSettingsSlotArgs = WebAppAuthSettingsSlotArgs(
        aadClaimsAuthorization = aadClaimsAuthorization,
        additionalLoginParams = additionalLoginParams,
        allowedAudiences = allowedAudiences,
        allowedExternalRedirectUrls = allowedExternalRedirectUrls,
        authFilePath = authFilePath,
        clientId = clientId,
        clientSecret = clientSecret,
        clientSecretCertificateThumbprint = clientSecretCertificateThumbprint,
        clientSecretSettingName = clientSecretSettingName,
        configVersion = configVersion,
        defaultProvider = defaultProvider,
        enabled = enabled,
        facebookAppId = facebookAppId,
        facebookAppSecret = facebookAppSecret,
        facebookAppSecretSettingName = facebookAppSecretSettingName,
        facebookOAuthScopes = facebookOAuthScopes,
        gitHubClientId = gitHubClientId,
        gitHubClientSecret = gitHubClientSecret,
        gitHubClientSecretSettingName = gitHubClientSecretSettingName,
        gitHubOAuthScopes = gitHubOAuthScopes,
        googleClientId = googleClientId,
        googleClientSecret = googleClientSecret,
        googleClientSecretSettingName = googleClientSecretSettingName,
        googleOAuthScopes = googleOAuthScopes,
        isAuthFromFile = isAuthFromFile,
        issuer = issuer,
        kind = kind,
        microsoftAccountClientId = microsoftAccountClientId,
        microsoftAccountClientSecret = microsoftAccountClientSecret,
        microsoftAccountClientSecretSettingName = microsoftAccountClientSecretSettingName,
        microsoftAccountOAuthScopes = microsoftAccountOAuthScopes,
        name = name,
        resourceGroupName = resourceGroupName,
        runtimeVersion = runtimeVersion,
        slot = slot,
        tokenRefreshExtensionHours = tokenRefreshExtensionHours,
        tokenStoreEnabled = tokenStoreEnabled,
        twitterConsumerKey = twitterConsumerKey,
        twitterConsumerSecret = twitterConsumerSecret,
        twitterConsumerSecretSettingName = twitterConsumerSecretSettingName,
        unauthenticatedClientAction = unauthenticatedClientAction,
        validateIssuer = validateIssuer,
    )
}
