@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.AuthPlatformResponse
import com.pulumi.azurenative.web.kotlin.outputs.GlobalValidationResponse
import com.pulumi.azurenative.web.kotlin.outputs.HttpSettingsResponse
import com.pulumi.azurenative.web.kotlin.outputs.IdentityProvidersResponse
import com.pulumi.azurenative.web.kotlin.outputs.LoginResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.web.kotlin.outputs.AuthPlatformResponse.Companion.toKotlin as authPlatformResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.GlobalValidationResponse.Companion.toKotlin as globalValidationResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.HttpSettingsResponse.Companion.toKotlin as httpSettingsResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.IdentityProvidersResponse.Companion.toKotlin as identityProvidersResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.LoginResponse.Companion.toKotlin as loginResponseToKotlin

/**
 * Builder for [WebAppAuthSettingsV2].
 */
@PulumiTagMarker
public class WebAppAuthSettingsV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppAuthSettingsV2Args = WebAppAuthSettingsV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppAuthSettingsV2ArgsBuilder.() -> Unit) {
        val builder = WebAppAuthSettingsV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppAuthSettingsV2 {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppAuthSettingsV2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppAuthSettingsV2(builtJavaResource)
    }
}

/**
 * Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
 * Azure REST API version: 2021-02-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAuthSettingsV2 myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2
 * ```
 */
public class WebAppAuthSettingsV2 internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppAuthSettingsV2,
) : KotlinCustomResource(javaResource, WebAppAuthSettingsV2Mapper) {
    /**
     * The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
     */
    public val globalValidation: Output<GlobalValidationResponse>?
        get() = javaResource.globalValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> globalValidationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.
     */
    public val httpSettings: Output<HttpSettingsResponse>?
        get() = javaResource.httpSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    httpSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
     */
    public val identityProviders: Output<IdentityProvidersResponse>?
        get() = javaResource.identityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> identityProvidersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The configuration settings of the login flow of users using App Service Authentication/Authorization.
     */
    public val login: Output<LoginResponse>?
        get() = javaResource.login().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loginResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The configuration settings of the platform of App Service Authentication/Authorization.
     */
    public val platform: Output<AuthPlatformResponse>?
        get() = javaResource.platform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    authPlatformResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppAuthSettingsV2Mapper : ResourceMapper<WebAppAuthSettingsV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppAuthSettingsV2::class == javaResource::class

    override fun map(javaResource: Resource): WebAppAuthSettingsV2 = WebAppAuthSettingsV2(
        javaResource
            as com.pulumi.azurenative.web.WebAppAuthSettingsV2,
    )
}

/**
 * @see [WebAppAuthSettingsV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppAuthSettingsV2].
 */
public suspend fun webAppAuthSettingsV2(
    name: String,
    block: suspend WebAppAuthSettingsV2ResourceBuilder.() -> Unit,
): WebAppAuthSettingsV2 {
    val builder = WebAppAuthSettingsV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppAuthSettingsV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppAuthSettingsV2(name: String): WebAppAuthSettingsV2 {
    val builder = WebAppAuthSettingsV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
