@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppAzureStorageAccountsSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.AzureStorageInfoValueArgs
import com.pulumi.azurenative.web.kotlin.inputs.AzureStorageInfoValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AzureStorageInfo dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAzureStorageAccountsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property properties Azure storage accounts.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage account configurations for the production slot.
 */
public data class WebAppAzureStorageAccountsSlotArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, AzureStorageInfoValueArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppAzureStorageAccountsSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppAzureStorageAccountsSlotArgs =
        com.pulumi.azurenative.web.WebAppAzureStorageAccountsSlotArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppAzureStorageAccountsSlotArgs].
 */
@PulumiTagMarker
public class WebAppAzureStorageAccountsSlotArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, AzureStorageInfoValueArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("ejjkleclwnmddyik")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("pjktdddwhnfxybha")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure storage accounts.
     */
    @JvmName("ayhjfmggeubnyyrs")
    public suspend fun properties(`value`: Output<Map<String, AzureStorageInfoValueArgs>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bievctngmvasebbf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the Azure storage account configurations for the production slot.
     */
    @JvmName("qontsqjruvfemsmi")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("kxsrhqtxbvfiadpe")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("dxhprwnstlyeiqmr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Azure storage accounts.
     */
    @JvmName("hfyokefntdxhktdp")
    public suspend fun properties(`value`: Map<String, AzureStorageInfoValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Azure storage accounts.
     */
    @JvmName("furodtsjuibxvwqs")
    public suspend fun properties(vararg argument: Pair<String, suspend AzureStorageInfoValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureStorageInfoValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values Azure storage accounts.
     */
    @JvmName("hulnmnyasaabauwm")
    public fun properties(vararg values: Pair<String, AzureStorageInfoValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wjhufboajeovxanp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the Azure storage account configurations for the production slot.
     */
    @JvmName("thfwmlpphbmgeyxc")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppAzureStorageAccountsSlotArgs = WebAppAzureStorageAccountsSlotArgs(
        kind = kind,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        slot = slot,
    )
}
