@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppBackupConfigurationSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.BackupScheduleArgs
import com.pulumi.azurenative.web.kotlin.inputs.BackupScheduleArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.DatabaseBackupSettingArgs
import com.pulumi.azurenative.web.kotlin.inputs.DatabaseBackupSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of a backup which will be performed.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppBackupConfigurationSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup
 * ```
 * @property backupName Name of the backup.
 * @property backupSchedule Schedule for the backup if it is executed periodically.
 * @property databases Databases included in the backup.
 * @property enabled True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the backup configuration for the production slot.
 * @property storageAccountUrl SAS URL to the container.
 */
public data class WebAppBackupConfigurationSlotArgs(
    public val backupName: Output<String>? = null,
    public val backupSchedule: Output<BackupScheduleArgs>? = null,
    public val databases: Output<List<DatabaseBackupSettingArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val storageAccountUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppBackupConfigurationSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppBackupConfigurationSlotArgs =
        com.pulumi.azurenative.web.WebAppBackupConfigurationSlotArgs.builder()
            .backupName(backupName?.applyValue({ args0 -> args0 }))
            .backupSchedule(backupSchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databases(
                databases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .storageAccountUrl(storageAccountUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppBackupConfigurationSlotArgs].
 */
@PulumiTagMarker
public class WebAppBackupConfigurationSlotArgsBuilder internal constructor() {
    private var backupName: Output<String>? = null

    private var backupSchedule: Output<BackupScheduleArgs>? = null

    private var databases: Output<List<DatabaseBackupSettingArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    private var storageAccountUrl: Output<String>? = null

    /**
     * @param value Name of the backup.
     */
    @JvmName("ysohogypqmxotmsi")
    public suspend fun backupName(`value`: Output<String>) {
        this.backupName = value
    }

    /**
     * @param value Schedule for the backup if it is executed periodically.
     */
    @JvmName("hfiassmlpcimpyus")
    public suspend fun backupSchedule(`value`: Output<BackupScheduleArgs>) {
        this.backupSchedule = value
    }

    /**
     * @param value Databases included in the backup.
     */
    @JvmName("tybtsqlvrmepvokf")
    public suspend fun databases(`value`: Output<List<DatabaseBackupSettingArgs>>) {
        this.databases = value
    }

    @JvmName("yuvvfwhtnxerluff")
    public suspend fun databases(vararg values: Output<DatabaseBackupSettingArgs>) {
        this.databases = Output.all(values.asList())
    }

    /**
     * @param values Databases included in the backup.
     */
    @JvmName("vwhixspubvbpjwbd")
    public suspend fun databases(values: List<Output<DatabaseBackupSettingArgs>>) {
        this.databases = Output.all(values)
    }

    /**
     * @param value True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    @JvmName("vnharsxjkddpiphm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("rdqbipbxxjinirqi")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("hyksahekbavqowjv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("qvirviqoinwppcwm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the backup configuration for the production slot.
     */
    @JvmName("ulupfcdatsneewhh")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value SAS URL to the container.
     */
    @JvmName("qwagnahpwdpuyrqi")
    public suspend fun storageAccountUrl(`value`: Output<String>) {
        this.storageAccountUrl = value
    }

    /**
     * @param value Name of the backup.
     */
    @JvmName("eeydxukuupdjcidy")
    public suspend fun backupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupName = mapped
    }

    /**
     * @param value Schedule for the backup if it is executed periodically.
     */
    @JvmName("caahsausuawlsspp")
    public suspend fun backupSchedule(`value`: BackupScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSchedule = mapped
    }

    /**
     * @param argument Schedule for the backup if it is executed periodically.
     */
    @JvmName("ihcaoedjafhpxswt")
    public suspend fun backupSchedule(argument: suspend BackupScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = BackupScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupSchedule = mapped
    }

    /**
     * @param value Databases included in the backup.
     */
    @JvmName("hfampvlsvhmovmgy")
    public suspend fun databases(`value`: List<DatabaseBackupSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("ffwsajmjrhqqqohl")
    public suspend fun databases(argument: List<suspend DatabaseBackupSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("nrdvdelpwsrfaeag")
    public suspend fun databases(vararg argument: suspend DatabaseBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatabaseBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument Databases included in the backup.
     */
    @JvmName("bdyvqbthwtfcfysn")
    public suspend fun databases(argument: suspend DatabaseBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatabaseBackupSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param values Databases included in the backup.
     */
    @JvmName("mlkyoimpfpukamlj")
    public suspend fun databases(vararg values: DatabaseBackupSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param value True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
     */
    @JvmName("fphremweccmncvcg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("bvlxrigjycnbursm")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ucbswhfvmrwadija")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uxkaolyvovopdtca")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the backup configuration for the production slot.
     */
    @JvmName("kxcdcfddukkguprv")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value SAS URL to the container.
     */
    @JvmName("wuovtqtbvsqiikkc")
    public suspend fun storageAccountUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountUrl = mapped
    }

    internal fun build(): WebAppBackupConfigurationSlotArgs = WebAppBackupConfigurationSlotArgs(
        backupName = backupName,
        backupSchedule = backupSchedule,
        databases = databases,
        enabled = enabled,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        slot = slot,
        storageAccountUrl = storageAccountUrl,
    )
}
