@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppHostNameBinding].
 */
@PulumiTagMarker
public class WebAppHostNameBindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppHostNameBindingArgs = WebAppHostNameBindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppHostNameBindingArgsBuilder.() -> Unit) {
        val builder = WebAppHostNameBindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppHostNameBinding {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppHostNameBinding(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppHostNameBinding(builtJavaResource)
    }
}

/**
 * A hostname binding object.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppHostNameBinding myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}
 * ```
 */
public class WebAppHostNameBinding internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppHostNameBinding,
) : KotlinCustomResource(javaResource, WebAppHostNameBindingMapper) {
    /**
     * Azure resource name.
     */
    public val azureResourceName: Output<String>?
        get() = javaResource.azureResourceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val azureResourceType: Output<String>?
        get() = javaResource.azureResourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom DNS record type.
     */
    public val customHostNameDnsRecordType: Output<String>?
        get() = javaResource.customHostNameDnsRecordType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Fully qualified ARM domain resource URI.
     */
    public val domainId: Output<String>?
        get() = javaResource.domainId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Hostname type.
     */
    public val hostNameType: Output<String>?
        get() = javaResource.hostNameType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * App Service app name.
     */
    public val siteName: Output<String>?
        get() = javaResource.siteName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * SSL type
     */
    public val sslState: Output<String>?
        get() = javaResource.sslState().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * SSL certificate thumbprint
     */
    public val thumbprint: Output<String>?
        get() = javaResource.thumbprint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Virtual IP address assigned to the hostname if IP based SSL is enabled.
     */
    public val virtualIP: Output<String>
        get() = javaResource.virtualIP().applyValue({ args0 -> args0 })
}

public object WebAppHostNameBindingMapper : ResourceMapper<WebAppHostNameBinding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppHostNameBinding::class == javaResource::class

    override fun map(javaResource: Resource): WebAppHostNameBinding =
        WebAppHostNameBinding(javaResource as com.pulumi.azurenative.web.WebAppHostNameBinding)
}

/**
 * @see [WebAppHostNameBinding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppHostNameBinding].
 */
public suspend fun webAppHostNameBinding(
    name: String,
    block: suspend WebAppHostNameBindingResourceBuilder.() -> Unit,
): WebAppHostNameBinding {
    val builder = WebAppHostNameBindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppHostNameBinding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppHostNameBinding(name: String): WebAppHostNameBinding {
    val builder = WebAppHostNameBindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
