@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppPremierAddOn].
 */
@PulumiTagMarker
public class WebAppPremierAddOnResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppPremierAddOnArgs = WebAppPremierAddOnArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppPremierAddOnArgsBuilder.() -> Unit) {
        val builder = WebAppPremierAddOnArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppPremierAddOn {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppPremierAddOn(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppPremierAddOn(builtJavaResource)
    }
}

/**
 * Premier add-on.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPremierAddOn myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}
 * ```
 */
public class WebAppPremierAddOn internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppPremierAddOn,
) : KotlinCustomResource(javaResource, WebAppPremierAddOnMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Premier add on Marketplace offer.
     */
    public val marketplaceOffer: Output<String>?
        get() = javaResource.marketplaceOffer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Premier add on Marketplace publisher.
     */
    public val marketplacePublisher: Output<String>?
        get() = javaResource.marketplacePublisher().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Premier add on Product.
     */
    public val product: Output<String>?
        get() = javaResource.product().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Premier add on SKU.
     */
    public val sku: Output<String>?
        get() = javaResource.sku().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Premier add on Vendor.
     */
    public val vendor: Output<String>?
        get() = javaResource.vendor().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WebAppPremierAddOnMapper : ResourceMapper<WebAppPremierAddOn> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppPremierAddOn::class == javaResource::class

    override fun map(javaResource: Resource): WebAppPremierAddOn = WebAppPremierAddOn(
        javaResource as
            com.pulumi.azurenative.web.WebAppPremierAddOn,
    )
}

/**
 * @see [WebAppPremierAddOn].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppPremierAddOn].
 */
public suspend fun webAppPremierAddOn(
    name: String,
    block: suspend WebAppPremierAddOnResourceBuilder.() -> Unit,
): WebAppPremierAddOn {
    val builder = WebAppPremierAddOnResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppPremierAddOn].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppPremierAddOn(name: String): WebAppPremierAddOn {
    val builder = WebAppPremierAddOnResourceBuilder()
    builder.name(name)
    return builder.build()
}
