@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ArmIdWrapperResponse
import com.pulumi.azurenative.web.kotlin.outputs.PrivateLinkConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.web.kotlin.outputs.ArmIdWrapperResponse.Companion.toKotlin as armIdWrapperResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.PrivateLinkConnectionStateResponse.Companion.toKotlin as privateLinkConnectionStateResponseToKotlin

/**
 * Builder for [WebAppPrivateEndpointConnection].
 */
@PulumiTagMarker
public class WebAppPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppPrivateEndpointConnectionArgs = WebAppPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = WebAppPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Remote Private Endpoint Connection ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection for a site.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppPrivateEndpointConnection = new AzureNative.Web.WebAppPrivateEndpointConnection("webAppPrivateEndpointConnection", new()
 *     {
 *         Name = "testSite",
 *         PrivateEndpointConnectionName = "connection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Web.Inputs.PrivateLinkConnectionStateArgs
 *         {
 *             ActionsRequired = "",
 *             Description = "Approved by admin.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppPrivateEndpointConnection(ctx, "webAppPrivateEndpointConnection", &web.WebAppPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("testSite"),
 * 			PrivateEndpointConnectionName: pulumi.String("connection"),
 * 			PrivateLinkServiceConnectionState: &web.PrivateLinkConnectionStateArgs{
 * 				ActionsRequired: pulumi.String(""),
 * 				Description:     pulumi.String("Approved by admin."),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnection;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.web.inputs.PrivateLinkConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppPrivateEndpointConnection = new WebAppPrivateEndpointConnection("webAppPrivateEndpointConnection", WebAppPrivateEndpointConnectionArgs.builder()
 *             .name("testSite")
 *             .privateEndpointConnectionName("connection")
 *             .privateLinkServiceConnectionState(PrivateLinkConnectionStateArgs.builder()
 *                 .actionsRequired("")
 *                 .description("Approved by admin.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPrivateEndpointConnection connection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class WebAppPrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, WebAppPrivateEndpointConnectionMapper) {
    /**
     * Private IPAddresses mapped to the remote private endpoint
     */
    public val ipAddresses: Output<List<String>>?
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * PrivateEndpoint of a remote private endpoint connection
     */
    public val privateEndpoint: Output<ArmIdWrapperResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> armIdWrapperResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The state of a private link connection
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppPrivateEndpointConnectionMapper :
    ResourceMapper<WebAppPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): WebAppPrivateEndpointConnection =
        WebAppPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.web.WebAppPrivateEndpointConnection,
        )
}

/**
 * @see [WebAppPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppPrivateEndpointConnection].
 */
public suspend fun webAppPrivateEndpointConnection(
    name: String,
    block: suspend WebAppPrivateEndpointConnectionResourceBuilder.() -> Unit,
): WebAppPrivateEndpointConnection {
    val builder = WebAppPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppPrivateEndpointConnection(name: String): WebAppPrivateEndpointConnection {
    val builder = WebAppPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
