@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSiteContainerArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.AuthType
import com.pulumi.azurenative.web.kotlin.inputs.EnvironmentVariableArgs
import com.pulumi.azurenative.web.kotlin.inputs.EnvironmentVariableArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.VolumeMountArgs
import com.pulumi.azurenative.web.kotlin.inputs.VolumeMountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container of a site
 * Azure REST API version: 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteContainer myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sitecontainers/{containerName}
 * ```
 * @property authType Auth Type
 * @property containerName Site Container Name
 * @property environmentVariables List of environment variables
 * @property image Image Name
 * @property isMain <code>true</code> if the container is the main site container; <code>false</code> otherwise.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property passwordSecret Password Secret
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property startUpCommand StartUp Command
 * @property targetPort Target Port
 * @property userManagedIdentityClientId UserManagedIdentity ClientId
 * @property userName User Name
 * @property volumeMounts List of volume mounts
 */
public data class WebAppSiteContainerArgs(
    public val authType: Output<AuthType>? = null,
    public val containerName: Output<String>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>? = null,
    public val isMain: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val passwordSecret: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startUpCommand: Output<String>? = null,
    public val targetPort: Output<String>? = null,
    public val userManagedIdentityClientId: Output<String>? = null,
    public val userName: Output<String>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSiteContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSiteContainerArgs =
        com.pulumi.azurenative.web.WebAppSiteContainerArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image?.applyValue({ args0 -> args0 }))
            .isMain(isMain?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .passwordSecret(passwordSecret?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startUpCommand(startUpCommand?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 }))
            .userManagedIdentityClientId(userManagedIdentityClientId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAppSiteContainerArgs].
 */
@PulumiTagMarker
public class WebAppSiteContainerArgsBuilder internal constructor() {
    private var authType: Output<AuthType>? = null

    private var containerName: Output<String>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var isMain: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var passwordSecret: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var startUpCommand: Output<String>? = null

    private var targetPort: Output<String>? = null

    private var userManagedIdentityClientId: Output<String>? = null

    private var userName: Output<String>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value Auth Type
     */
    @JvmName("dyunibrmvydkqsvu")
    public suspend fun authType(`value`: Output<AuthType>) {
        this.authType = value
    }

    /**
     * @param value Site Container Name
     */
    @JvmName("dpbvkvnaoyioibaj")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value List of environment variables
     */
    @JvmName("khsjlpybiyhsomst")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("rvxjjxrokgqhylwa")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values List of environment variables
     */
    @JvmName("uyeiacsceuowmgsf")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Image Name
     */
    @JvmName("ocqerkrlnqrqagsu")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    @JvmName("esggbwrmrgsbwfwk")
    public suspend fun isMain(`value`: Output<Boolean>) {
        this.isMain = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("htbabqgsagdiieaa")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("hnmavdnyyqfblbmr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password Secret
     */
    @JvmName("bgmbysfxulirvbbv")
    public suspend fun passwordSecret(`value`: Output<String>) {
        this.passwordSecret = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("pwxbqawhllmcvcoa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value StartUp Command
     */
    @JvmName("ripmyeghhdtbtctm")
    public suspend fun startUpCommand(`value`: Output<String>) {
        this.startUpCommand = value
    }

    /**
     * @param value Target Port
     */
    @JvmName("incfntqsxbivphkt")
    public suspend fun targetPort(`value`: Output<String>) {
        this.targetPort = value
    }

    /**
     * @param value UserManagedIdentity ClientId
     */
    @JvmName("igjfpnmjmcwmtxgv")
    public suspend fun userManagedIdentityClientId(`value`: Output<String>) {
        this.userManagedIdentityClientId = value
    }

    /**
     * @param value User Name
     */
    @JvmName("bmggkdtbmibtjsvs")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value List of volume mounts
     */
    @JvmName("mdawomvbybeejjde")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("tqvyxhxecxsgxewe")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values List of volume mounts
     */
    @JvmName("xsyvfmtaxxmhvhoc")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Auth Type
     */
    @JvmName("ohjljiogwxletuns")
    public suspend fun authType(`value`: AuthType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Site Container Name
     */
    @JvmName("lorftfslnebensbp")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value List of environment variables
     */
    @JvmName("paypviiavesqpugl")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("yhagyjsctgmeigim")
    public suspend fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("rlolupjamaybijmj")
    public suspend fun environmentVariables(vararg argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("eqryoepvdaxoyynb")
    public suspend fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values List of environment variables
     */
    @JvmName("unnyhlghlqwjxvhx")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Image Name
     */
    @JvmName("hryvtfqxjywkcoom")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    @JvmName("wxgfpxbctmyvhhyb")
    public suspend fun isMain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMain = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("snvcfqbitwsjotnh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("nvsgakbwrxyopiig")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password Secret
     */
    @JvmName("ntabmywiieprmgip")
    public suspend fun passwordSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecret = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("kbfdutmfpshtxnvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value StartUp Command
     */
    @JvmName("rpljjpelkppkbses")
    public suspend fun startUpCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startUpCommand = mapped
    }

    /**
     * @param value Target Port
     */
    @JvmName("wvyexbfoanqlwnne")
    public suspend fun targetPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    /**
     * @param value UserManagedIdentity ClientId
     */
    @JvmName("jvaqgherrtdjbdyk")
    public suspend fun userManagedIdentityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userManagedIdentityClientId = mapped
    }

    /**
     * @param value User Name
     */
    @JvmName("qxkjdppyhrytlhek")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value List of volume mounts
     */
    @JvmName("vjwvtqbbumlwspqn")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("ctrkhqsttypygcdq")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("kijqcprenqgqqtyt")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("xscdcwdkugqwqsqx")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values List of volume mounts
     */
    @JvmName("fthvirlfceobqvwn")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): WebAppSiteContainerArgs = WebAppSiteContainerArgs(
        authType = authType,
        containerName = containerName,
        environmentVariables = environmentVariables,
        image = image,
        isMain = isMain,
        kind = kind,
        name = name,
        passwordSecret = passwordSecret,
        resourceGroupName = resourceGroupName,
        startUpCommand = startUpCommand,
        targetPort = targetPort,
        userManagedIdentityClientId = userManagedIdentityClientId,
        userName = userName,
        volumeMounts = volumeMounts,
    )
}
