@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.EnvironmentVariableResponse
import com.pulumi.azurenative.web.kotlin.outputs.VolumeMountResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.web.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin as environmentVariableResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.VolumeMountResponse.Companion.toKotlin as volumeMountResponseToKotlin

/**
 * Builder for [WebAppSiteContainerSlot].
 */
@PulumiTagMarker
public class WebAppSiteContainerSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSiteContainerSlotArgs = WebAppSiteContainerSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSiteContainerSlotArgsBuilder.() -> Unit) {
        val builder = WebAppSiteContainerSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppSiteContainerSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSiteContainerSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSiteContainerSlot(builtJavaResource)
    }
}

/**
 * Container of a site
 * Azure REST API version: 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteContainerSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers/{containerName}
 * ```
 */
public class WebAppSiteContainerSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSiteContainerSlot,
) : KotlinCustomResource(javaResource, WebAppSiteContainerSlotMapper) {
    /**
     * Auth Type
     */
    public val authType: Output<String>?
        get() = javaResource.authType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Created Time
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * List of environment variables
     */
    public val environmentVariables: Output<List<EnvironmentVariableResponse>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        environmentVariableResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Image Name
     */
    public val image: Output<String>
        get() = javaResource.image().applyValue({ args0 -> args0 })

    /**
     * <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    public val isMain: Output<Boolean>
        get() = javaResource.isMain().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Last Modified Time
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Password Secret
     */
    public val passwordSecret: Output<String>?
        get() = javaResource.passwordSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * StartUp Command
     */
    public val startUpCommand: Output<String>?
        get() = javaResource.startUpCommand().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Target Port
     */
    public val targetPort: Output<String>?
        get() = javaResource.targetPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * UserManagedIdentity ClientId
     */
    public val userManagedIdentityClientId: Output<String>?
        get() = javaResource.userManagedIdentityClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User Name
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of volume mounts
     */
    public val volumeMounts: Output<List<VolumeMountResponse>>?
        get() = javaResource.volumeMounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> volumeMountResponseToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object WebAppSiteContainerSlotMapper : ResourceMapper<WebAppSiteContainerSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSiteContainerSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSiteContainerSlot =
        WebAppSiteContainerSlot(javaResource as com.pulumi.azurenative.web.WebAppSiteContainerSlot)
}

/**
 * @see [WebAppSiteContainerSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSiteContainerSlot].
 */
public suspend fun webAppSiteContainerSlot(
    name: String,
    block: suspend WebAppSiteContainerSlotResourceBuilder.() -> Unit,
): WebAppSiteContainerSlot {
    val builder = WebAppSiteContainerSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSiteContainerSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSiteContainerSlot(name: String): WebAppSiteContainerSlot {
    val builder = WebAppSiteContainerSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
