@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSiteContainerSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.AuthType
import com.pulumi.azurenative.web.kotlin.inputs.EnvironmentVariableArgs
import com.pulumi.azurenative.web.kotlin.inputs.EnvironmentVariableArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.VolumeMountArgs
import com.pulumi.azurenative.web.kotlin.inputs.VolumeMountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container of a site
 * Azure REST API version: 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteContainerSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sitecontainers/{containerName}
 * ```
 * @property authType Auth Type
 * @property containerName Site Container Name
 * @property environmentVariables List of environment variables
 * @property image Image Name
 * @property isMain <code>true</code> if the container is the main site container; <code>false</code> otherwise.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property passwordSecret Password Secret
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will create the container for the production slot.
 * @property startUpCommand StartUp Command
 * @property targetPort Target Port
 * @property userManagedIdentityClientId UserManagedIdentity ClientId
 * @property userName User Name
 * @property volumeMounts List of volume mounts
 */
public data class WebAppSiteContainerSlotArgs(
    public val authType: Output<AuthType>? = null,
    public val containerName: Output<String>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>? = null,
    public val isMain: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val passwordSecret: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val startUpCommand: Output<String>? = null,
    public val targetPort: Output<String>? = null,
    public val userManagedIdentityClientId: Output<String>? = null,
    public val userName: Output<String>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSiteContainerSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSiteContainerSlotArgs =
        com.pulumi.azurenative.web.WebAppSiteContainerSlotArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image?.applyValue({ args0 -> args0 }))
            .isMain(isMain?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .passwordSecret(passwordSecret?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .startUpCommand(startUpCommand?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 }))
            .userManagedIdentityClientId(userManagedIdentityClientId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAppSiteContainerSlotArgs].
 */
@PulumiTagMarker
public class WebAppSiteContainerSlotArgsBuilder internal constructor() {
    private var authType: Output<AuthType>? = null

    private var containerName: Output<String>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var isMain: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var passwordSecret: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    private var startUpCommand: Output<String>? = null

    private var targetPort: Output<String>? = null

    private var userManagedIdentityClientId: Output<String>? = null

    private var userName: Output<String>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value Auth Type
     */
    @JvmName("ckutcdagnqdwflmr")
    public suspend fun authType(`value`: Output<AuthType>) {
        this.authType = value
    }

    /**
     * @param value Site Container Name
     */
    @JvmName("alyexhwhrrmrwpvv")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value List of environment variables
     */
    @JvmName("wvrsgekxgnxewxfu")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("xvlyraeejluajciu")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values List of environment variables
     */
    @JvmName("anftkkkjgordtsbq")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Image Name
     */
    @JvmName("aiejnsoeiyofpqmo")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    @JvmName("srdeyxsmjmwpbsqn")
    public suspend fun isMain(`value`: Output<Boolean>) {
        this.isMain = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("wcruaxdnujdeheua")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("sbnitveyulmxmirw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Password Secret
     */
    @JvmName("jyuswembqjjrisbw")
    public suspend fun passwordSecret(`value`: Output<String>) {
        this.passwordSecret = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("yolrbuujpfhheehm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will create the container for the production slot.
     */
    @JvmName("uxirstppwdelexwi")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value StartUp Command
     */
    @JvmName("eiqmdyxciwhgibye")
    public suspend fun startUpCommand(`value`: Output<String>) {
        this.startUpCommand = value
    }

    /**
     * @param value Target Port
     */
    @JvmName("bqpiiayvketgbcbo")
    public suspend fun targetPort(`value`: Output<String>) {
        this.targetPort = value
    }

    /**
     * @param value UserManagedIdentity ClientId
     */
    @JvmName("hmahblakbaxyarel")
    public suspend fun userManagedIdentityClientId(`value`: Output<String>) {
        this.userManagedIdentityClientId = value
    }

    /**
     * @param value User Name
     */
    @JvmName("alwilgrqhlabmwsr")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value List of volume mounts
     */
    @JvmName("tmhvvougmhwyxuha")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("kgxblubaogbovcxl")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values List of volume mounts
     */
    @JvmName("kgmaxebgmniutgfy")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Auth Type
     */
    @JvmName("yhydhgmfvrmgepvh")
    public suspend fun authType(`value`: AuthType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Site Container Name
     */
    @JvmName("yvmfadousimidohw")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value List of environment variables
     */
    @JvmName("rbkydwxenbvsaxqx")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("ornxpneqohfgqkjc")
    public suspend fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("jkkvenwbjptdsqpr")
    public suspend fun environmentVariables(vararg argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables
     */
    @JvmName("arxjvcocitfqyfgh")
    public suspend fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values List of environment variables
     */
    @JvmName("dobmgqpiihyngtkr")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Image Name
     */
    @JvmName("dvnsycneahnoyhsk")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    @JvmName("cyxoxkbwdahsahlk")
    public suspend fun isMain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMain = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("tedbbpjkxwasacwh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jxplnrbipqqprvpr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Password Secret
     */
    @JvmName("mqyiunqxtglqodcq")
    public suspend fun passwordSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecret = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nvvxbnkrvicdqaje")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will create the container for the production slot.
     */
    @JvmName("qgnslvqccndtdxqx")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value StartUp Command
     */
    @JvmName("xfxkmwikpjfhjcbu")
    public suspend fun startUpCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startUpCommand = mapped
    }

    /**
     * @param value Target Port
     */
    @JvmName("wfycqlqvieginrpr")
    public suspend fun targetPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    /**
     * @param value UserManagedIdentity ClientId
     */
    @JvmName("cgncgwiopdfefjtn")
    public suspend fun userManagedIdentityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userManagedIdentityClientId = mapped
    }

    /**
     * @param value User Name
     */
    @JvmName("jkvlapwkoamvxvcw")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value List of volume mounts
     */
    @JvmName("fdsvqcaupguiwiwn")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("tdmehabduiyiqxmk")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("vajppjhtkanqdqdt")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument List of volume mounts
     */
    @JvmName("kpobxrseofvukcnt")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values List of volume mounts
     */
    @JvmName("mqqiecaiedgcjgap")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): WebAppSiteContainerSlotArgs = WebAppSiteContainerSlotArgs(
        authType = authType,
        containerName = containerName,
        environmentVariables = environmentVariables,
        image = image,
        isMain = isMain,
        kind = kind,
        name = name,
        passwordSecret = passwordSecret,
        resourceGroupName = resourceGroupName,
        slot = slot,
        startUpCommand = startUpCommand,
        targetPort = targetPort,
        userManagedIdentityClientId = userManagedIdentityClientId,
        userName = userName,
        volumeMounts = volumeMounts,
    )
}
