@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WebAppSlotConfigurationNames].
 */
@PulumiTagMarker
public class WebAppSlotConfigurationNamesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSlotConfigurationNamesArgs = WebAppSlotConfigurationNamesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSlotConfigurationNamesArgsBuilder.() -> Unit) {
        val builder = WebAppSlotConfigurationNamesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppSlotConfigurationNames {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSlotConfigurationNames(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSlotConfigurationNames(builtJavaResource)
    }
}

/**
 * Slot Config names azure resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSlotConfigurationNames myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames
 * ```
 */
public class WebAppSlotConfigurationNames internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSlotConfigurationNames,
) : KotlinCustomResource(javaResource, WebAppSlotConfigurationNamesMapper) {
    /**
     * List of application settings names.
     */
    public val appSettingNames: Output<List<String>>?
        get() = javaResource.appSettingNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of external Azure storage account identifiers.
     */
    public val azureStorageConfigNames: Output<List<String>>?
        get() = javaResource.azureStorageConfigNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of connection string names.
     */
    public val connectionStringNames: Output<List<String>>?
        get() = javaResource.connectionStringNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppSlotConfigurationNamesMapper : ResourceMapper<WebAppSlotConfigurationNames> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSlotConfigurationNames::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSlotConfigurationNames =
        WebAppSlotConfigurationNames(
            javaResource as
                com.pulumi.azurenative.web.WebAppSlotConfigurationNames,
        )
}

/**
 * @see [WebAppSlotConfigurationNames].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSlotConfigurationNames].
 */
public suspend fun webAppSlotConfigurationNames(
    name: String,
    block: suspend WebAppSlotConfigurationNamesResourceBuilder.() -> Unit,
): WebAppSlotConfigurationNames {
    val builder = WebAppSlotConfigurationNamesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSlotConfigurationNames].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSlotConfigurationNames(name: String): WebAppSlotConfigurationNames {
    val builder = WebAppSlotConfigurationNamesResourceBuilder()
    builder.name(name)
    return builder.build()
}
