@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.GitHubActionConfigurationResponse
import com.pulumi.azurenative.web.kotlin.outputs.GitHubActionConfigurationResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppSourceControlSlot].
 */
@PulumiTagMarker
public class WebAppSourceControlSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSourceControlSlotArgs = WebAppSourceControlSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSourceControlSlotArgsBuilder.() -> Unit) {
        val builder = WebAppSourceControlSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppSourceControlSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSourceControlSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSourceControlSlot(builtJavaResource)
    }
}

/**
 * Source control configuration for an app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSourceControlSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web
 * ```
 */
public class WebAppSourceControlSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSourceControlSlot,
) : KotlinCustomResource(javaResource, WebAppSourceControlSlotMapper) {
    /**
     * Name of branch to use for deployment.
     */
    public val branch: Output<String>?
        get() = javaResource.branch().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
     */
    public val deploymentRollbackEnabled: Output<Boolean>?
        get() = javaResource.deploymentRollbackEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If GitHub Action is selected, than the associated configuration.
     */
    public val gitHubActionConfiguration: Output<GitHubActionConfigurationResponse>?
        get() = javaResource.gitHubActionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * <code>true</code> if this is deployed via GitHub action.
     */
    public val isGitHubAction: Output<Boolean>?
        get() = javaResource.isGitHubAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
     */
    public val isManualIntegration: Output<Boolean>?
        get() = javaResource.isManualIntegration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
     */
    public val isMercurial: Output<Boolean>?
        get() = javaResource.isMercurial().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Repository or source control URL.
     */
    public val repoUrl: Output<String>?
        get() = javaResource.repoUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppSourceControlSlotMapper : ResourceMapper<WebAppSourceControlSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSourceControlSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSourceControlSlot =
        WebAppSourceControlSlot(javaResource as com.pulumi.azurenative.web.WebAppSourceControlSlot)
}

/**
 * @see [WebAppSourceControlSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSourceControlSlot].
 */
public suspend fun webAppSourceControlSlot(
    name: String,
    block: suspend WebAppSourceControlSlotResourceBuilder.() -> Unit,
): WebAppSourceControlSlot {
    val builder = WebAppSourceControlSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSourceControlSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSourceControlSlot(name: String): WebAppSourceControlSlot {
    val builder = WebAppSourceControlSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
