@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppSwiftVirtualNetworkConnectionSlot].
 */
@PulumiTagMarker
public class WebAppSwiftVirtualNetworkConnectionSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSwiftVirtualNetworkConnectionSlotArgs =
        WebAppSwiftVirtualNetworkConnectionSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSwiftVirtualNetworkConnectionSlotArgsBuilder.() -> Unit) {
        val builder = WebAppSwiftVirtualNetworkConnectionSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppSwiftVirtualNetworkConnectionSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSwiftVirtualNetworkConnectionSlot(builtJavaResource)
    }
}

/**
 * Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01, 2023-12-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSwiftVirtualNetworkConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork
 * ```
 */
public class WebAppSwiftVirtualNetworkConnectionSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlot,
) : KotlinCustomResource(javaResource, WebAppSwiftVirtualNetworkConnectionSlotMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     */
    public val subnetResourceId: Output<String>?
        get() = javaResource.subnetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A flag that specifies if the scale unit this Web App is on supports Swift integration.
     */
    public val swiftSupported: Output<Boolean>?
        get() = javaResource.swiftSupported().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppSwiftVirtualNetworkConnectionSlotMapper :
    ResourceMapper<WebAppSwiftVirtualNetworkConnectionSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSwiftVirtualNetworkConnectionSlot =
        WebAppSwiftVirtualNetworkConnectionSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlot,
        )
}

/**
 * @see [WebAppSwiftVirtualNetworkConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSwiftVirtualNetworkConnectionSlot].
 */
public suspend fun webAppSwiftVirtualNetworkConnectionSlot(
    name: String,
    block: suspend WebAppSwiftVirtualNetworkConnectionSlotResourceBuilder.() -> Unit,
): WebAppSwiftVirtualNetworkConnectionSlot {
    val builder = WebAppSwiftVirtualNetworkConnectionSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSwiftVirtualNetworkConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSwiftVirtualNetworkConnectionSlot(name: String): WebAppSwiftVirtualNetworkConnectionSlot {
    val builder = WebAppSwiftVirtualNetworkConnectionSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
