@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Auth Type
 */
public enum class AuthType(
    public val javaValue: com.pulumi.azurenative.web.enums.AuthType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.AuthType> {
    Anonymous(com.pulumi.azurenative.web.enums.AuthType.Anonymous),
    UserCredentials(com.pulumi.azurenative.web.enums.AuthType.UserCredentials),
    SystemIdentity(com.pulumi.azurenative.web.enums.AuthType.SystemIdentity),
    UserAssigned(com.pulumi.azurenative.web.enums.AuthType.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.AuthType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.AuthType): AuthType =
            AuthType.values().first { it.javaValue == javaType }
    }
}
