@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of database.
 */
public enum class ConnectionStringType(
    public val javaValue: com.pulumi.azurenative.web.enums.ConnectionStringType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.ConnectionStringType> {
    MySql(com.pulumi.azurenative.web.enums.ConnectionStringType.MySql),
    SQLServer(com.pulumi.azurenative.web.enums.ConnectionStringType.SQLServer),
    SQLAzure(com.pulumi.azurenative.web.enums.ConnectionStringType.SQLAzure),
    Custom(com.pulumi.azurenative.web.enums.ConnectionStringType.Custom),
    NotificationHub(com.pulumi.azurenative.web.enums.ConnectionStringType.NotificationHub),
    ServiceBus(com.pulumi.azurenative.web.enums.ConnectionStringType.ServiceBus),
    EventHub(com.pulumi.azurenative.web.enums.ConnectionStringType.EventHub),
    ApiHub(com.pulumi.azurenative.web.enums.ConnectionStringType.ApiHub),
    DocDb(com.pulumi.azurenative.web.enums.ConnectionStringType.DocDb),
    RedisCache(com.pulumi.azurenative.web.enums.ConnectionStringType.RedisCache),
    PostgreSQL(com.pulumi.azurenative.web.enums.ConnectionStringType.PostgreSQL),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.ConnectionStringType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.ConnectionStringType): ConnectionStringType = ConnectionStringType.values().first { it.javaValue == javaType }
    }
}
