@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the hostname is a standard or repository hostname.
 */
public enum class HostType(
    public val javaValue: com.pulumi.azurenative.web.enums.HostType,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.HostType> {
    Standard(com.pulumi.azurenative.web.enums.HostType.Standard),
    Repository(com.pulumi.azurenative.web.enums.HostType.Repository),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.HostType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.HostType): HostType =
            HostType.values().first { it.javaValue == javaType }
    }
}
