@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Site load balancing.
 */
public enum class SiteLoadBalancing(
    public val javaValue: com.pulumi.azurenative.web.enums.SiteLoadBalancing,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.SiteLoadBalancing> {
    WeightedRoundRobin(com.pulumi.azurenative.web.enums.SiteLoadBalancing.WeightedRoundRobin),
    LeastRequests(com.pulumi.azurenative.web.enums.SiteLoadBalancing.LeastRequests),
    LeastResponseTime(com.pulumi.azurenative.web.enums.SiteLoadBalancing.LeastResponseTime),
    WeightedTotalTraffic(com.pulumi.azurenative.web.enums.SiteLoadBalancing.WeightedTotalTraffic),
    RequestHash(com.pulumi.azurenative.web.enums.SiteLoadBalancing.RequestHash),
    PerSiteRoundRobin(com.pulumi.azurenative.web.enums.SiteLoadBalancing.PerSiteRoundRobin),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.SiteLoadBalancing = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.SiteLoadBalancing): SiteLoadBalancing = SiteLoadBalancing.values().first { it.javaValue == javaType }
    }
}
