@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The action to take when an unauthenticated client attempts to access the app.
 */
public enum class UnauthenticatedClientActionV2(
    public val javaValue: com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2> {
    RedirectToLoginPage(com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2.RedirectToLoginPage),
    AllowAnonymous(com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2.AllowAnonymous),
    Return401(com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2.Return401),
    Return403(com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2.Return403),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2 = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.UnauthenticatedClientActionV2): UnauthenticatedClientActionV2 =
            UnauthenticatedClientActionV2.values().first { it.javaValue == javaType }
    }
}
