@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Upgrade Preference
 */
public enum class UpgradePreference(
    public val javaValue: com.pulumi.azurenative.web.enums.UpgradePreference,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.UpgradePreference> {
    /**
     * No preference on when this App Service Environment will be upgraded
     */
    None(com.pulumi.azurenative.web.enums.UpgradePreference.None),

    /**
     * This App Service Environment will be upgraded before others in the same region that have Upgrade Preference 'Late'
     */
    Early(com.pulumi.azurenative.web.enums.UpgradePreference.Early),

    /**
     * This App Service Environment will be upgraded after others in the same region that have Upgrade Preference 'Early'
     */
    Late(com.pulumi.azurenative.web.enums.UpgradePreference.Late),

    /**
     * ASEv3 only. Once an upgrade is available, this App Service Environment will wait 10 days for the upgrade to be manually initiated. After 10 days the upgrade will begin automatically
     */
    Manual(com.pulumi.azurenative.web.enums.UpgradePreference.Manual),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.UpgradePreference = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.UpgradePreference): UpgradePreference = UpgradePreference.values().first { it.javaValue == javaType }
    }
}
