@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiManagementConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure API management (APIM) configuration linked to the app.
 * @property id APIM-Api Identifier.
 */
public data class ApiManagementConfigArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiManagementConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiManagementConfigArgs =
        com.pulumi.azurenative.web.inputs.ApiManagementConfigArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiManagementConfigArgs].
 */
@PulumiTagMarker
public class ApiManagementConfigArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value APIM-Api Identifier.
     */
    @JvmName("vuvfqfrxtyjlgaky")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value APIM-Api Identifier.
     */
    @JvmName("grgcfsapljwncmjn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ApiManagementConfigArgs = ApiManagementConfigArgs(
        id = id,
    )
}
