@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AuthPlatformArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the platform of App Service Authentication/Authorization.
 * @property configFilePath The path of the config file containing auth settings if they come from a file.
 * If the path is relative, base will the site's root directory.
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 */
public data class AuthPlatformArgs(
    public val configFilePath: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val runtimeVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AuthPlatformArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AuthPlatformArgs =
        com.pulumi.azurenative.web.inputs.AuthPlatformArgs.builder()
            .configFilePath(configFilePath?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthPlatformArgs].
 */
@PulumiTagMarker
public class AuthPlatformArgsBuilder internal constructor() {
    private var configFilePath: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value The path of the config file containing auth settings if they come from a file.
     * If the path is relative, base will the site's root directory.
     */
    @JvmName("abrjorwyhofangro")
    public suspend fun configFilePath(`value`: Output<String>) {
        this.configFilePath = value
    }

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("gluedispfxrphsxm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("almqhnjqlyeyrlwa")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value The path of the config file containing auth settings if they come from a file.
     * If the path is relative, base will the site's root directory.
     */
    @JvmName("dlnhxmvvbbmofnle")
    public suspend fun configFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configFilePath = mapped
    }

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("dqeppfhewxtjbvqn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("mklrjhnubxmjbxna")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): AuthPlatformArgs = AuthPlatformArgs(
        configFilePath = configFilePath,
        enabled = enabled,
        runtimeVersion = runtimeVersion,
    )
}
