@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureActiveDirectoryLoginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory login flow.
 * @property disableWWWAuthenticate <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
 * @property loginParameters Login parameters to send to the OpenID Connect authorization endpoint when
 * a user logs in. Each parameter must be in the form "key=value".
 */
public data class AzureActiveDirectoryLoginArgs(
    public val disableWWWAuthenticate: Output<Boolean>? = null,
    public val loginParameters: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureActiveDirectoryLoginArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureActiveDirectoryLoginArgs =
        com.pulumi.azurenative.web.inputs.AzureActiveDirectoryLoginArgs.builder()
            .disableWWWAuthenticate(disableWWWAuthenticate?.applyValue({ args0 -> args0 }))
            .loginParameters(loginParameters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureActiveDirectoryLoginArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryLoginArgsBuilder internal constructor() {
    private var disableWWWAuthenticate: Output<Boolean>? = null

    private var loginParameters: Output<List<String>>? = null

    /**
     * @param value <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
     */
    @JvmName("wahgmddrqpymvvyv")
    public suspend fun disableWWWAuthenticate(`value`: Output<Boolean>) {
        this.disableWWWAuthenticate = value
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("uismjboskkdgbjlq")
    public suspend fun loginParameters(`value`: Output<List<String>>) {
        this.loginParameters = value
    }

    @JvmName("eyxcyknfrnuxaxnf")
    public suspend fun loginParameters(vararg values: Output<String>) {
        this.loginParameters = Output.all(values.asList())
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("pyvkdqxolvxodtvf")
    public suspend fun loginParameters(values: List<Output<String>>) {
        this.loginParameters = Output.all(values)
    }

    /**
     * @param value <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
     */
    @JvmName("vwnxwnmiilsvyxrn")
    public suspend fun disableWWWAuthenticate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableWWWAuthenticate = mapped
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("mdywtgwodkaqyrsx")
    public suspend fun loginParameters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginParameters = mapped
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("vcimpkhitokdsrsa")
    public suspend fun loginParameters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginParameters = mapped
    }

    internal fun build(): AzureActiveDirectoryLoginArgs = AzureActiveDirectoryLoginArgs(
        disableWWWAuthenticate = disableWWWAuthenticate,
        loginParameters = loginParameters,
    )
}
