@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureActiveDirectoryRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory app registration.
 * @property clientId The Client ID of this relying party application, known as the client_id.
 * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
 * other 3rd party OpenID Connect providers.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecretCertificateIssuer An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
 * @property clientSecretCertificateSubjectAlternativeName An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
 * @property clientSecretCertificateThumbprint An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret. It is also optional.
 * @property clientSecretSettingName The app setting name that contains the client secret of the relying party application.
 * @property openIdIssuer The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
 * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
 * This URI is a case-sensitive identifier for the token issuer.
 * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
 */
public data class AzureActiveDirectoryRegistrationArgs(
    public val clientId: Output<String>? = null,
    public val clientSecretCertificateIssuer: Output<String>? = null,
    public val clientSecretCertificateSubjectAlternativeName: Output<String>? = null,
    public val clientSecretCertificateThumbprint: Output<String>? = null,
    public val clientSecretSettingName: Output<String>? = null,
    public val openIdIssuer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureActiveDirectoryRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureActiveDirectoryRegistrationArgs =
        com.pulumi.azurenative.web.inputs.AzureActiveDirectoryRegistrationArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecretCertificateIssuer(clientSecretCertificateIssuer?.applyValue({ args0 -> args0 }))
            .clientSecretCertificateSubjectAlternativeName(
                clientSecretCertificateSubjectAlternativeName?.applyValue({ args0 ->
                    args0
                }),
            )
            .clientSecretCertificateThumbprint(
                clientSecretCertificateThumbprint?.applyValue({ args0 ->
                    args0
                }),
            )
            .clientSecretSettingName(clientSecretSettingName?.applyValue({ args0 -> args0 }))
            .openIdIssuer(openIdIssuer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureActiveDirectoryRegistrationArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryRegistrationArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecretCertificateIssuer: Output<String>? = null

    private var clientSecretCertificateSubjectAlternativeName: Output<String>? = null

    private var clientSecretCertificateThumbprint: Output<String>? = null

    private var clientSecretSettingName: Output<String>? = null

    private var openIdIssuer: Output<String>? = null

    /**
     * @param value The Client ID of this relying party application, known as the client_id.
     * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
     * other 3rd party OpenID Connect providers.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("vglgfnxqxjqbanio")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
     */
    @JvmName("aggkgebopuadaldr")
    public suspend fun clientSecretCertificateIssuer(`value`: Output<String>) {
        this.clientSecretCertificateIssuer = value
    }

    /**
     * @param value An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
     */
    @JvmName("gvsdqjshaupjkeil")
    public suspend fun clientSecretCertificateSubjectAlternativeName(`value`: Output<String>) {
        this.clientSecretCertificateSubjectAlternativeName = value
    }

    /**
     * @param value An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret. It is also optional.
     */
    @JvmName("gvfvmqhvuyhwiitx")
    public suspend fun clientSecretCertificateThumbprint(`value`: Output<String>) {
        this.clientSecretCertificateThumbprint = value
    }

    /**
     * @param value The app setting name that contains the client secret of the relying party application.
     */
    @JvmName("isyruumtqilitqki")
    public suspend fun clientSecretSettingName(`value`: Output<String>) {
        this.clientSecretSettingName = value
    }

    /**
     * @param value The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
     * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     * This URI is a case-sensitive identifier for the token issuer.
     * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
     */
    @JvmName("htyetgifrqklhmut")
    public suspend fun openIdIssuer(`value`: Output<String>) {
        this.openIdIssuer = value
    }

    /**
     * @param value The Client ID of this relying party application, known as the client_id.
     * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
     * other 3rd party OpenID Connect providers.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    @JvmName("jujwogrveqogbwxx")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
     */
    @JvmName("vcgvhhftipmsoxmk")
    public suspend fun clientSecretCertificateIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretCertificateIssuer = mapped
    }

    /**
     * @param value An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
     */
    @JvmName("nkyrlxafpiervpvs")
    public suspend fun clientSecretCertificateSubjectAlternativeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretCertificateSubjectAlternativeName = mapped
    }

    /**
     * @param value An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret. It is also optional.
     */
    @JvmName("qcpwodgttrdhgmsd")
    public suspend fun clientSecretCertificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretCertificateThumbprint = mapped
    }

    /**
     * @param value The app setting name that contains the client secret of the relying party application.
     */
    @JvmName("fqhrnoqqoieqdudk")
    public suspend fun clientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretSettingName = mapped
    }

    /**
     * @param value The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
     * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     * This URI is a case-sensitive identifier for the token issuer.
     * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
     */
    @JvmName("csasjhdpwpabeuag")
    public suspend fun openIdIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openIdIssuer = mapped
    }

    internal fun build(): AzureActiveDirectoryRegistrationArgs = AzureActiveDirectoryRegistrationArgs(
        clientId = clientId,
        clientSecretCertificateIssuer = clientSecretCertificateIssuer,
        clientSecretCertificateSubjectAlternativeName = clientSecretCertificateSubjectAlternativeName,
        clientSecretCertificateThumbprint = clientSecretCertificateThumbprint,
        clientSecretSettingName = clientSecretSettingName,
        openIdIssuer = openIdIssuer,
    )
}
