@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureBlobStorageApplicationLogsConfigArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.LogLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application logs azure blob storage configuration.
 * @property level Log level.
 * @property retentionInDays Retention in days.
 * Remove blobs older than X days.
 * 0 or lower means no retention.
 * @property sasUrl SAS url to a azure blob container with read/write/list/delete permissions.
 */
public data class AzureBlobStorageApplicationLogsConfigArgs(
    public val level: Output<LogLevel>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val sasUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureBlobStorageApplicationLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureBlobStorageApplicationLogsConfigArgs = com.pulumi.azurenative.web.inputs.AzureBlobStorageApplicationLogsConfigArgs.builder()
        .level(level?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
        .sasUrl(sasUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobStorageApplicationLogsConfigArgs].
 */
@PulumiTagMarker
public class AzureBlobStorageApplicationLogsConfigArgsBuilder internal constructor() {
    private var level: Output<LogLevel>? = null

    private var retentionInDays: Output<Int>? = null

    private var sasUrl: Output<String>? = null

    /**
     * @param value Log level.
     */
    @JvmName("bdttlqhxshbynhjh")
    public suspend fun level(`value`: Output<LogLevel>) {
        this.level = value
    }

    /**
     * @param value Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("gsmjgoesaotvgjgd")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value SAS url to a azure blob container with read/write/list/delete permissions.
     */
    @JvmName("vsfjuinkxvvkpsxd")
    public suspend fun sasUrl(`value`: Output<String>) {
        this.sasUrl = value
    }

    /**
     * @param value Log level.
     */
    @JvmName("ytttoxsadmyomblf")
    public suspend fun level(`value`: LogLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("naexxtcfpqtwislg")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value SAS url to a azure blob container with read/write/list/delete permissions.
     */
    @JvmName("dfjnuglokebplbjq")
    public suspend fun sasUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUrl = mapped
    }

    internal fun build(): AzureBlobStorageApplicationLogsConfigArgs =
        AzureBlobStorageApplicationLogsConfigArgs(
            level = level,
            retentionInDays = retentionInDays,
            sasUrl = sasUrl,
        )
}
