@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureBlobStorageHttpLogsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Http logs to azure blob storage configuration.
 * @property enabled True if configuration is enabled, false if it is disabled and null if configuration is not set.
 * @property retentionInDays Retention in days.
 * Remove blobs older than X days.
 * 0 or lower means no retention.
 * @property sasUrl SAS url to a azure blob container with read/write/list/delete permissions.
 */
public data class AzureBlobStorageHttpLogsConfigArgs(
    public val enabled: Output<Boolean>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val sasUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureBlobStorageHttpLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureBlobStorageHttpLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.AzureBlobStorageHttpLogsConfigArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .sasUrl(sasUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobStorageHttpLogsConfigArgs].
 */
@PulumiTagMarker
public class AzureBlobStorageHttpLogsConfigArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var retentionInDays: Output<Int>? = null

    private var sasUrl: Output<String>? = null

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("icplibicpaeipbjk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("orhrnnlxrfdrsjpw")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value SAS url to a azure blob container with read/write/list/delete permissions.
     */
    @JvmName("iydswshyylknvxqk")
    public suspend fun sasUrl(`value`: Output<String>) {
        this.sasUrl = value
    }

    /**
     * @param value True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    @JvmName("bitaqxdgeyvhiskx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    @JvmName("awxnmndcswdthitb")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value SAS url to a azure blob container with read/write/list/delete permissions.
     */
    @JvmName("wqfiiguawgoogikf")
    public suspend fun sasUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUrl = mapped
    }

    internal fun build(): AzureBlobStorageHttpLogsConfigArgs = AzureBlobStorageHttpLogsConfigArgs(
        enabled = enabled,
        retentionInDays = retentionInDays,
        sasUrl = sasUrl,
    )
}
