@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureTableStorageApplicationLogsConfigArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.LogLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application logs to Azure table storage configuration.
 * @property level Log level.
 * @property sasUrl SAS URL to an Azure table with add/query/delete permissions.
 */
public data class AzureTableStorageApplicationLogsConfigArgs(
    public val level: Output<LogLevel>? = null,
    public val sasUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureTableStorageApplicationLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureTableStorageApplicationLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.AzureTableStorageApplicationLogsConfigArgs.builder()
            .level(level?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasUrl(sasUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureTableStorageApplicationLogsConfigArgs].
 */
@PulumiTagMarker
public class AzureTableStorageApplicationLogsConfigArgsBuilder internal constructor() {
    private var level: Output<LogLevel>? = null

    private var sasUrl: Output<String>? = null

    /**
     * @param value Log level.
     */
    @JvmName("jornsedqgrkkokcj")
    public suspend fun level(`value`: Output<LogLevel>) {
        this.level = value
    }

    /**
     * @param value SAS URL to an Azure table with add/query/delete permissions.
     */
    @JvmName("fssqhbwjwsmuuaaw")
    public suspend fun sasUrl(`value`: Output<String>) {
        this.sasUrl = value
    }

    /**
     * @param value Log level.
     */
    @JvmName("mxcpaycqvtweblhn")
    public suspend fun level(`value`: LogLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value SAS URL to an Azure table with add/query/delete permissions.
     */
    @JvmName("uojiakbrxjqpoqlq")
    public suspend fun sasUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sasUrl = mapped
    }

    internal fun build(): AzureTableStorageApplicationLogsConfigArgs =
        AzureTableStorageApplicationLogsConfigArgs(
            level = level,
            sasUrl = sasUrl ?: throw PulumiNullFieldException("sasUrl"),
        )
}
